/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Preconditions;
import org.lwjgl.opengl.GL11;

public class ManualDisplayList {
    private int displayList;
    private boolean isAllocated;
    private boolean isValid;

    public boolean isCompiled() {
        return this.isValid;
    }

    public void render() {
        Preconditions.checkState((boolean)this.isValid, (Object)"Display list not initialized");
        GL11.glCallList((int)this.displayList);
    }

    public void compile(Renderer renderer) {
        if (this.isAllocated) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
        }
        this.displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        renderer.render();
        GL11.glEndList();
        this.isValid = true;
        this.isAllocated = true;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public static interface Renderer {
        public void render();
    }
}

