/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagMobPveListener {
    @Listener
    public void onMobPve(DamageEntityEvent event, @First EntityDamageSource source) {
        if (!(event.getTargetEntity() instanceof Player) && source.getSource() instanceof Player) {
            this.handleEvent(event, event.getTargetEntity(), (Player)source.getSource());
        }
    }

    private void handleEvent(DamageEntityEvent event, Entity entity, Player player) {
        EntityType type = entity.getType();
        if (!FlagUtils.isBlockEntity(type) && !FlagUtils.isVehicle(type) && entity instanceof Living) {
            String name = type.getId().toLowerCase();
            Region region = RegionUtils.getRegion((Location<World>)entity.getLocation());
            if (region != null) {
                boolean cancel;
                boolean relatedAllFlag;
                boolean bl = relatedAllFlag = !region.getMobPve("all");
                if (entity instanceof Monster) {
                    boolean bl2 = relatedAllFlag = relatedAllFlag || !region.getMobPve("allhostile");
                }
                if (entity instanceof Creature || entity instanceof Animal) {
                    relatedAllFlag = relatedAllFlag || !region.getMobPve("allpassive");
                }
                boolean bl3 = cancel = relatedAllFlag || !region.getMobPve(name) && !PermissionUtils.hasPermission(player, RegionPermission.REGION);
                if (cancel) {
                    event.setCancelled(true);
                    MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                }
            }
        }
    }
}

