/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.universeguard.command.RegionAddEffectExecutor;
import com.universeguard.command.RegionAddExecutor;
import com.universeguard.command.RegionAtExecutor;
import com.universeguard.command.RegionBlockUseExecutor;
import com.universeguard.command.RegionBuyExecutor;
import com.universeguard.command.RegionCommandExecutor;
import com.universeguard.command.RegionCopyExecutor;
import com.universeguard.command.RegionCreateExecutor;
import com.universeguard.command.RegionDeleteExecutor;
import com.universeguard.command.RegionDiscardExecutor;
import com.universeguard.command.RegionEditExecutor;
import com.universeguard.command.RegionExcludeBlockExecutor;
import com.universeguard.command.RegionExecutor;
import com.universeguard.command.RegionExpandExecutor;
import com.universeguard.command.RegionFarewellExecutor;
import com.universeguard.command.RegionFlagExecutor;
import com.universeguard.command.RegionFlagInfoExecutor;
import com.universeguard.command.RegionGamemodeExecutor;
import com.universeguard.command.RegionGlobalForExecutor;
import com.universeguard.command.RegionGreetingExecutor;
import com.universeguard.command.RegionHelpExecutor;
import com.universeguard.command.RegionHereExecutor;
import com.universeguard.command.RegionIncludeBlockExecutor;
import com.universeguard.command.RegionInfoExecutor;
import com.universeguard.command.RegionItemUseExecutor;
import com.universeguard.command.RegionListExecutor;
import com.universeguard.command.RegionNameExecutor;
import com.universeguard.command.RegionPriorityExecutor;
import com.universeguard.command.RegionReloadExecutor;
import com.universeguard.command.RegionRemoveEffectExecutor;
import com.universeguard.command.RegionRemoveExecutor;
import com.universeguard.command.RegionRemoveFarewellExecutor;
import com.universeguard.command.RegionRemoveGreetingExecutor;
import com.universeguard.command.RegionRemoveValueExecutor;
import com.universeguard.command.RegionSaveExecutor;
import com.universeguard.command.RegionSellExecutor;
import com.universeguard.command.RegionSetExecutor;
import com.universeguard.command.RegionSetSpawnExecutor;
import com.universeguard.command.RegionSetTeleportExecutor;
import com.universeguard.command.RegionSetValueExecutor;
import com.universeguard.command.RegionSpawnExecutor;
import com.universeguard.command.RegionTeleportExecutor;
import com.universeguard.command.RegionTemplateExecutor;
import com.universeguard.command.argument.BooleanElement;
import com.universeguard.command.argument.FlagCommandElement;
import com.universeguard.command.argument.RegionNameElement;
import com.universeguard.command.argument.RegionOwnedNameElement;
import com.universeguard.command.argument.RegionPointCommandElement;
import com.universeguard.command.argument.RegionToBuyNameElement;
import com.universeguard.command.argument.RegionToSellNameElement;
import com.universeguard.command.argument.SubflagCommandElement;
import com.universeguard.event.EventPlayerJoin;
import com.universeguard.event.EventRegionSelect;
import com.universeguard.event.FlagEffectListener;
import com.universeguard.event.flags.FlagBlockUseListener;
import com.universeguard.event.flags.FlagCactusDamageListener;
import com.universeguard.event.flags.FlagChestsListener;
import com.universeguard.event.flags.FlagCommandListener;
import com.universeguard.event.flags.FlagDestroyListener;
import com.universeguard.event.flags.FlagDrownListener;
import com.universeguard.event.flags.FlagEnderChestsListener;
import com.universeguard.event.flags.FlagEnderDragonBlockDamageListener;
import com.universeguard.event.flags.FlagEnderPearlListener;
import com.universeguard.event.flags.FlagEndermanGriefListener;
import com.universeguard.event.flags.FlagEnterListener;
import com.universeguard.event.flags.FlagExitListener;
import com.universeguard.event.flags.FlagExpDropListener;
import com.universeguard.event.flags.FlagExplosionDamageListener;
import com.universeguard.event.flags.FlagExplosionDestroyListener;
import com.universeguard.event.flags.FlagFallDamageListener;
import com.universeguard.event.flags.FlagFarewellListener;
import com.universeguard.event.flags.FlagFireDamageListener;
import com.universeguard.event.flags.FlagFireSpreadListener;
import com.universeguard.event.flags.FlagFishingPoleListener;
import com.universeguard.event.flags.FlagFrostWalkerListener;
import com.universeguard.event.flags.FlagGamemodeListener;
import com.universeguard.event.flags.FlagGreetingListener;
import com.universeguard.event.flags.FlagHungerListener;
import com.universeguard.event.flags.FlagIceMeltListener;
import com.universeguard.event.flags.FlagInteractListener;
import com.universeguard.event.flags.FlagInvincibleListener;
import com.universeguard.event.flags.FlagItemDropListener;
import com.universeguard.event.flags.FlagItemPickupListener;
import com.universeguard.event.flags.FlagItemUseListener;
import com.universeguard.event.flags.FlagLavaFlowListener;
import com.universeguard.event.flags.FlagLeafDecayListener;
import com.universeguard.event.flags.FlagLighterListener;
import com.universeguard.event.flags.FlagMobDamageListener;
import com.universeguard.event.flags.FlagMobDropListener;
import com.universeguard.event.flags.FlagMobInteractListener;
import com.universeguard.event.flags.FlagMobPveListener;
import com.universeguard.event.flags.FlagMobSpawnListener;
import com.universeguard.event.flags.FlagOtherLiquidsFlowListener;
import com.universeguard.event.flags.FlagPistonsListener;
import com.universeguard.event.flags.FlagPlaceListener;
import com.universeguard.event.flags.FlagPotionSplashListener;
import com.universeguard.event.flags.FlagPvpListener;
import com.universeguard.event.flags.FlagSendChatListener;
import com.universeguard.event.flags.FlagShulkerBoxesListener;
import com.universeguard.event.flags.FlagSleepListener;
import com.universeguard.event.flags.FlagTrampleListener;
import com.universeguard.event.flags.FlagTrappedChestsListener;
import com.universeguard.event.flags.FlagVehicleDestroyListener;
import com.universeguard.event.flags.FlagVehiclePlaceListener;
import com.universeguard.event.flags.FlagVinesGrowthListener;
import com.universeguard.event.flags.FlagWallDamageListener;
import com.universeguard.event.flags.FlagWaterFlowListener;
import com.universeguard.region.GlobalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumDirection;
import com.universeguard.region.enums.EnumRegionBlock;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.CommandUtils;
import com.universeguard.utils.EventUtils;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.LogUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import com.universeguard.utils.TranslationUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.World;

@Plugin(id="universeguard", name="Universe Guard 2", version="2.25", description="An easy to use world protection plugin for Sponge", authors={"JimiIT92, Brycey92, eheimer"})
public class UniverseGuard {
    static final String VERSION = "2.25";
    public static final float REGION_VERSION = Float.parseFloat("2.25");
    static final String ID = "universeguard";
    public static final String NAME = "Universe Guard 2";
    static final String DESCRIPTION = "An easy to use world protection plugin for Sponge";
    static final String AUTHOR = "JimiIT92, Brycey92, eheimer";
    public static int HUNGER_TIMER = 5;
    public static int GAMEMODE_TIMER = 5;
    public static int ENTER_FLAG_TIMER = 100;
    public static int EFFECT_TIMER = 100;
    public static boolean UNIQUE_REGIONS = true;
    public static boolean LIMIT_REGIONS_SIZE = false;
    public static int MAX_REGION_SIZE = 100;
    public static boolean LIMIT_PLAYER_REGIONS = false;
    public static int MAX_REGIONS = 10;
    public static HashMap<String, Integer> MAX_PERMISSION_REGIONS = new HashMap();
    public static boolean PURCHASABLE_REGIONS = false;
    public static boolean USE_EFFECTS = false;
    public static UniverseGuard INSTANCE;
    @Inject
    private Logger LOGGER;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private File CONFIG;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private ConfigurationLoader<CommentedConfigurationNode> CONFIG_LOADER;
    private CommentedConfigurationNode CONFIG_NODE;
    @Inject
    private Game GAME;
    public static ArrayList<Region> ALL_REGIONS;
    public static ItemType SELECTOR_ITEM;

    @Listener
    public void onInit(GameInitializationEvent event) {
        LogUtils.init(this.LOGGER);
        LogUtils.print(RegionText.LOADING.getValue(), "init");
        INSTANCE = this;
        this.loadConfig();
        ALL_REGIONS = RegionUtils.getAllRegions();
        RegionUtils.loadSellingRegions();
        this.registerCommands();
        this.registerEvents();
        LogUtils.print(RegionText.LOADED.getValue(), "init");
    }

    @Listener
    public void onGameStart(GameStartedServerEvent event) {
        LogUtils.print(RegionText.CONFIGURATION_UPDATING_REGIONS.getValue(), "init");
        for (World w : Sponge.getServer().getWorlds()) {
            if (RegionUtils.load(w.getName()) != null) continue;
            RegionUtils.save(new GlobalRegion(w.getName(), false));
        }
        this.updateRegions();
        if (RegionUtils.shouldConvertOldRegions()) {
            LogUtils.print(RegionText.CONFIGURATION_CONVERTING_OLD_REGIONS.getValue(), "init");
            RegionUtils.convertOldRegions();
            LogUtils.print(RegionText.CONFIGURATION_OLD_REGIONS_CONVERTED.getValue(), "init");
        }
        LogUtils.print(RegionText.CONFIGURATION_REGIONS_UPDATED.getValue(), "init");
    }

    private void updateRegions() {
        ArrayList<Region> updatedRegions = new ArrayList<Region>();
        for (Region region : ALL_REGIONS) {
            if (region.getVersion() == REGION_VERSION) continue;
            updatedRegions.add(region);
        }
        for (Region region : updatedRegions) {
            RegionUtils.update(region);
        }
        RegionUtils.saveIndex();
    }

    private void loadConfig() {
        try {
            LogUtils.print(RegionText.LOADING_CONFIGURATION.getValue(), "init");
            if (!this.CONFIG.exists()) {
                this.CONFIG.createNewFile();
            }
            this.saveDefaultConfig();
            this.CONFIG_NODE = (CommentedConfigurationNode)this.CONFIG_LOADER.load();
            PermissionUtils.getValues(this.CONFIG_NODE);
            FlagUtils.getValues(this.GAME, this.CONFIG_NODE);
            TranslationUtils.getValues(this.CONFIG_NODE);
            LogUtils.print(RegionText.LOADED_CONFIGURATION.getValue(), "init");
        }
        catch (IOException e) {
            LogUtils.log(e.getMessage());
            LogUtils.print(TextColors.RED, RegionText.CONFIGURATION_LOADING_EXCEPTION.getValue(), "init");
        }
    }

    private void saveDefaultConfig() {
        try {
            this.CONFIG_NODE = (CommentedConfigurationNode)this.CONFIG_LOADER.load();
            PermissionUtils.setDefaultValues(this.CONFIG_NODE);
            FlagUtils.setDefaultValues(this.CONFIG_NODE);
            TranslationUtils.setDefaultValues(this.CONFIG_NODE);
            this.CONFIG_LOADER.save((ConfigurationNode)this.CONFIG_NODE);
        }
        catch (IOException e) {
            LogUtils.log(e.getMessage());
            LogUtils.print(TextColors.RED, RegionText.CONFIGURATION_SAVE_EXCEPTION.getValue(), "init");
        }
    }

    private void registerCommands() {
        CommandSpec regionSave = CommandUtils.buildCommandSpec("Save a region", (CommandExecutor)new RegionSaveExecutor(), RegionPermission.ALL.getValue());
        CommandSpec regionDiscard = CommandUtils.buildCommandSpec("Discard some region edits", (CommandExecutor)new RegionDiscardExecutor(), RegionPermission.ALL.getValue());
        CommandSpec regionName = CommandUtils.buildCommandSpec("Set the name of a region", (CommandExecutor)new RegionNameExecutor(), RegionPermission.ALL.getValue(), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"name")));
        CommandSpec regionDelete = CommandUtils.buildCommandSpec("Delete a region", (CommandExecutor)new RegionDeleteExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name"))});
        CommandSpec regionEdit = CommandUtils.buildCommandSpec("Allow editing a region", (CommandExecutor)new RegionEditExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name"))});
        CommandSpec regionInfo = CommandUtils.buildCommandSpec("Get informations about a region", (CommandExecutor)new RegionInfoExecutor(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name"))});
        CommandSpec regionPriority = CommandUtils.buildCommandSpec("Set the priority of a region", (CommandExecutor)new RegionPriorityExecutor(), RegionPermission.ALL.getValue(), GenericArguments.integer((Text)Text.of((String)"priority")));
        CommandSpec regionSetTeleport = CommandUtils.buildCommandSpec("Set the teleport location of a region", (CommandExecutor)new RegionSetTeleportExecutor(), RegionPermission.ALL.getValue(), GenericArguments.location((Text)Text.of((String)"location")));
        CommandSpec regionSetSpawn = CommandUtils.buildCommandSpec("Set the spawn location of a region", (CommandExecutor)new RegionSetSpawnExecutor(), RegionPermission.ALL.getValue(), GenericArguments.location((Text)Text.of((String)"location")));
        CommandSpec regionTeleport = CommandUtils.buildCommandSpec("Teleports to a region teleport location", (CommandExecutor)new RegionTeleportExecutor(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name"))});
        CommandSpec regionSpawn = CommandUtils.buildCommandSpec("Teleports to a region spawn location", (CommandExecutor)new RegionSpawnExecutor(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name"))});
        CommandSpec regionList = CommandUtils.buildCommandSpec("Show the list of all regions", new RegionListExecutor());
        CommandSpec regionGamemode = CommandUtils.buildCommandSpec("Set the gamemode of a region", (CommandExecutor)new RegionGamemodeExecutor(), RegionPermission.ALL.getValue(), GenericArguments.catalogedElement((Text)Text.of((String)"gamemode"), GameMode.class));
        CommandSpec regionHere = CommandUtils.buildCommandSpec("Tells wich region you are currently in", new RegionHereExecutor());
        CommandSpec regionReload = CommandUtils.buildCommandSpec("Reload cached regions", (CommandExecutor)new RegionReloadExecutor(), RegionPermission.ALL.getValue());
        CommandSpec regionFarewell = CommandUtils.buildCommandSpec("Set the farewell message of a region", (CommandExecutor)new RegionFarewellExecutor(), RegionPermission.ALL.getValue(), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"message")));
        CommandSpec regionGreeting = CommandUtils.buildCommandSpec("Set the greeting message of a region", (CommandExecutor)new RegionGreetingExecutor(), RegionPermission.ALL.getValue(), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"message")));
        CommandSpec regionCopy = CommandUtils.buildCommandSpec("Copy a region into a new one", (CommandExecutor)new RegionCopyExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new RegionNameElement((Text)Text.of((String)"name")), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"newRegion"))});
        CommandSpec regionAt = CommandUtils.buildCommandSpec("Tells wich region are at the give location", (CommandExecutor)new RegionAtExecutor(), GenericArguments.location((Text)Text.of((String)"location")));
        CommandSpec regionCreate = CommandUtils.buildCommandSpec("Create a region at thge specified location", (CommandExecutor)new RegionCreateExecutor(), RegionPermission.ALL.getValue(), GenericArguments.integer((Text)Text.of((String)"x1")), GenericArguments.integer((Text)Text.of((String)"y1")), GenericArguments.integer((Text)Text.of((String)"z1")), GenericArguments.integer((Text)Text.of((String)"x2")), GenericArguments.integer((Text)Text.of((String)"y2")), GenericArguments.integer((Text)Text.of((String)"z2")), GenericArguments.catalogedElement((Text)Text.of((String)"dimension"), DimensionType.class), GenericArguments.string((Text)Text.of((String)"world")), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"name")));
        CommandSpec regionSet = CommandUtils.buildCommandSpec("Set a point of a pending region", (CommandExecutor)new RegionSetExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new RegionPointCommandElement((Text)Text.of((String)"point")), GenericArguments.integer((Text)Text.of((String)"x")), GenericArguments.integer((Text)Text.of((String)"y")), GenericArguments.integer((Text)Text.of((String)"z"))});
        CommandSpec regionAddEffect = CommandUtils.buildCommandSpec("Add a potion effect to a Region", (CommandExecutor)new RegionAddEffectExecutor(), RegionPermission.ALL.getValue(), GenericArguments.catalogedElement((Text)Text.of((String)"effect"), PotionEffectType.class), GenericArguments.integer((Text)Text.of((String)"level")));
        CommandSpec regionRemoveEffect = CommandUtils.buildCommandSpec("Remove a potion effect to a Region", (CommandExecutor)new RegionRemoveEffectExecutor(), RegionPermission.ALL.getValue(), GenericArguments.catalogedElement((Text)Text.of((String)"effect"), PotionEffectType.class));
        CommandSpec regionSetValue = CommandUtils.buildCommandSpec("Sets the value of a Region", (CommandExecutor)new RegionSetValueExecutor(), new CommandElement[]{new RegionOwnedNameElement((Text)Text.of((String)"region")), GenericArguments.catalogedElement((Text)Text.of((String)"item"), ItemType.class), GenericArguments.integer((Text)Text.of((String)"quantity"))});
        CommandSpec regionRemoveValue = CommandUtils.buildCommandSpec("Remove a value from a Region", (CommandExecutor)new RegionRemoveValueExecutor(), new CommandElement[]{new RegionOwnedNameElement((Text)Text.of((String)"region"))});
        CommandSpec regionBuy = CommandUtils.buildCommandSpec("Buy a Region", (CommandExecutor)new RegionBuyExecutor(), new CommandElement[]{new RegionToBuyNameElement((Text)Text.of((String)"region"))});
        CommandSpec regionSell = CommandUtils.buildCommandSpec("Sells a Region", (CommandExecutor)new RegionSellExecutor(), new CommandElement[]{new RegionToSellNameElement((Text)Text.of((String)"region"))});
        CommandSpec regionExcludeBlock = CommandUtils.buildCommandSpec("Exclude a block from being handled by the place or the destroy flag", (CommandExecutor)new RegionExcludeBlockExecutor(), RegionPermission.ALL.getValue(), GenericArguments.catalogedElement((Text)Text.of((String)"block"), BlockType.class), GenericArguments.enumValue((Text)Text.of((String)"type"), EnumRegionBlock.class));
        CommandSpec regionIncludeBlock = CommandUtils.buildCommandSpec("Include a block from being handled by the place or the destroy flag", (CommandExecutor)new RegionIncludeBlockExecutor(), RegionPermission.ALL.getValue(), GenericArguments.catalogedElement((Text)Text.of((String)"block"), BlockType.class), GenericArguments.enumValue((Text)Text.of((String)"type"), EnumRegionBlock.class));
        CommandSpec regionTemplate = CommandUtils.buildCommandSpec("Sets or remove a pending Region from being a Template", (CommandExecutor)new RegionTemplateExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new BooleanElement((Text)Text.of((String)"template"))});
        CommandSpec regionRemoveFarewell = CommandUtils.buildCommandSpec("Removes the farewell message from a Region", (CommandExecutor)new RegionRemoveFarewellExecutor(), RegionPermission.ALL.getValue());
        CommandSpec regionRemoveGreeting = CommandUtils.buildCommandSpec("Removes the greeting message from a Region", (CommandExecutor)new RegionRemoveGreetingExecutor(), RegionPermission.ALL.getValue());
        CommandSpec regionItemUse = CommandUtils.buildCommandSpec("Sets if you can or can't use an item inside a Region", (CommandExecutor)new RegionItemUseExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new BooleanElement((Text)Text.of((String)"value")), GenericArguments.catalogedElement((Text)Text.of((String)"item"), ItemType.class)});
        CommandSpec regionBlockUse = CommandUtils.buildCommandSpec("Sets if you can or can't use a block inside a Region", (CommandExecutor)new RegionBlockUseExecutor(), RegionPermission.ALL.getValue(), new CommandElement[]{new BooleanElement((Text)Text.of((String)"value")), GenericArguments.catalogedElement((Text)Text.of((String)"block"), BlockType.class)});
        CommandSpec regionFlagInfo = CommandSpec.builder().description((Text)Text.of((String)"Get informations about a flag in a region")).executor((CommandExecutor)new RegionFlagInfoExecutor()).arguments(new CommandElement[]{GenericArguments.enumValue((Text)Text.of((String)"flag"), EnumRegionFlag.class), new RegionNameElement((Text)Text.of((String)"name"))}).build();
        CommandSpec regionHelp = CommandSpec.builder().description((Text)Text.of((String)"Show help")).executor((CommandExecutor)new RegionHelpExecutor()).arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"page"))), GenericArguments.optional((CommandElement)new BooleanElement((Text)Text.of((String)"flags")))}).build();
        CommandSpec regionAdd = CommandSpec.builder().description((Text)Text.of((String)"Add a player into a region")).executor((CommandExecutor)new RegionAddExecutor()).arguments(new CommandElement[]{GenericArguments.enumValue((Text)Text.of((String)"role"), RegionRole.class), GenericArguments.string((Text)Text.of((String)"name")), new RegionNameElement((Text)Text.of((String)"region"))}).build();
        CommandSpec regionRemove = CommandSpec.builder().description((Text)Text.of((String)"Remove a player from a region")).executor((CommandExecutor)new RegionRemoveExecutor()).arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"name")), new RegionNameElement((Text)Text.of((String)"region"))}).build();
        CommandSpec regionFlag = CommandSpec.builder().description((Text)Text.of((String)"Set the flag of a region")).executor((CommandExecutor)new RegionFlagExecutor()).arguments(new CommandElement[]{new SubflagCommandElement((Text)Text.of((String)"subflag")), new FlagCommandElement((Text)Text.of((String)"flag")), new BooleanElement((Text)Text.of((String)"value"))}).permission(RegionPermission.ALL.getValue()).build();
        CommandSpec regionCommand = CommandSpec.builder().description((Text)Text.of((String)"Allow or disallow a command in a region")).executor((CommandExecutor)new RegionCommandExecutor()).arguments(new CommandElement[]{new BooleanElement((Text)Text.of((String)"value")), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"command"))}).permission(RegionPermission.ALL.getValue()).build();
        CommandSpec regionExpand = CommandSpec.builder().description((Text)Text.of((String)"Expand the selection area of a region")).executor((CommandExecutor)new RegionExpandExecutor()).arguments(new CommandElement[]{GenericArguments.enumValue((Text)Text.of((String)"direction"), EnumDirection.class), GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"blocks")))}).permission(RegionPermission.ALL.getValue()).build();
        CommandSpec regionGlobalFor = CommandSpec.builder().description((Text)Text.of((String)"Create a global region for a dimension")).executor((CommandExecutor)new RegionGlobalForExecutor()).arguments(GenericArguments.string((Text)Text.of((String)"dimension"))).permission(RegionPermission.ALL.getValue()).build();
        CommandSpec region = CommandSpec.builder().description((Text)Text.of((String)"Region command")).executor((CommandExecutor)new RegionExecutor()).child((CommandCallable)regionSave, new String[]{"save"}).child((CommandCallable)regionName, new String[]{"name"}).child((CommandCallable)regionFlag, new String[]{"flag"}).child((CommandCallable)regionDelete, new String[]{"delete"}).child((CommandCallable)regionEdit, new String[]{"edit"}).child((CommandCallable)regionInfo, new String[]{"info"}).child((CommandCallable)regionPriority, new String[]{"priority"}).child((CommandCallable)regionSetTeleport, new String[]{"setteleport"}).child((CommandCallable)regionSetSpawn, new String[]{"setspawn"}).child((CommandCallable)regionTeleport, new String[]{"tp"}).child((CommandCallable)regionSpawn, new String[]{"spawn"}).child((CommandCallable)regionList, new String[]{"list"}).child((CommandCallable)regionAdd, new String[]{"add"}).child((CommandCallable)regionRemove, new String[]{"remove"}).child((CommandCallable)regionHelp, new String[]{"help"}).child((CommandCallable)regionGamemode, new String[]{"gamemode"}).child((CommandCallable)regionCommand, new String[]{"command"}).child((CommandCallable)regionExpand, new String[]{"expand"}).child((CommandCallable)regionFlagInfo, new String[]{"flaginfo"}).child((CommandCallable)regionHere, new String[]{"here"}).child((CommandCallable)regionReload, new String[]{"reload"}).child((CommandCallable)regionFarewell, new String[]{"farewell"}).child((CommandCallable)regionGreeting, new String[]{"greeting"}).child((CommandCallable)regionCopy, new String[]{"copy"}).child((CommandCallable)regionAt, new String[]{"at"}).child((CommandCallable)regionCreate, new String[]{"create"}).child((CommandCallable)regionSet, new String[]{"set"}).child((CommandCallable)regionAddEffect, new String[]{"effectadd"}).child((CommandCallable)regionRemoveEffect, new String[]{"effectremove"}).child((CommandCallable)regionSetValue, new String[]{"setvalue"}).child((CommandCallable)regionRemoveValue, new String[]{"removevalue"}).child((CommandCallable)regionBuy, new String[]{"buy"}).child((CommandCallable)regionSell, new String[]{"sell"}).child((CommandCallable)regionExcludeBlock, new String[]{"excludeblock"}).child((CommandCallable)regionIncludeBlock, new String[]{"includeblock"}).child((CommandCallable)regionTemplate, new String[]{"template"}).child((CommandCallable)regionRemoveFarewell, new String[]{"removefarewell"}).child((CommandCallable)regionRemoveGreeting, new String[]{"removegreeting"}).child((CommandCallable)regionItemUse, new String[]{"itemuse"}).child((CommandCallable)regionGlobalFor, new String[]{"globalfor"}).child((CommandCallable)regionDiscard, new String[]{"discard"}).child((CommandCallable)regionBlockUse, new String[]{"blockuse"}).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)region, (List)Lists.newArrayList((Object[])new String[]{"region", "rg"}));
    }

    private void registerEvents() {
        EventUtils.init(this.GAME);
        EventUtils.registerEvent(new EventRegionSelect());
        EventUtils.registerEvent(new FlagPlaceListener());
        EventUtils.registerEvent(new FlagDestroyListener());
        EventUtils.registerEvent(new FlagPvpListener());
        EventUtils.registerEvent(new FlagExpDropListener());
        EventUtils.registerEvent(new FlagItemDropListener());
        EventUtils.registerEvent(new FlagItemPickupListener());
        EventUtils.registerEvent(new FlagEnderPearlListener());
        EventUtils.registerEvent(new FlagSleepListener());
        EventUtils.registerEvent(new FlagLighterListener());
        EventUtils.registerEvent(new FlagChestsListener());
        EventUtils.registerEvent(new FlagTrappedChestsListener());
        EventUtils.registerEvent(new FlagEnderChestsListener());
        EventUtils.registerEvent(new FlagWaterFlowListener());
        EventUtils.registerEvent(new FlagLavaFlowListener());
        EventUtils.registerEvent(new FlagOtherLiquidsFlowListener());
        EventUtils.registerEvent(new FlagLeafDecayListener());
        EventUtils.registerEvent(new FlagFireSpreadListener());
        EventUtils.registerEvent(new FlagPotionSplashListener());
        EventUtils.registerEvent(new FlagFallDamageListener());
        EventUtils.registerEvent(new FlagWallDamageListener());
        EventUtils.registerEvent(new FlagDrownListener());
        EventUtils.registerEvent(new FlagCactusDamageListener());
        EventUtils.registerEvent(new FlagFireDamageListener());
        EventUtils.registerEvent(new FlagInvincibleListener());
        EventUtils.registerEvent(new FlagEndermanGriefListener());
        EventUtils.registerEvent(new FlagEnderDragonBlockDamageListener());
        EventUtils.registerEvent(new FlagInteractListener());
        EventUtils.registerEvent(new FlagVehiclePlaceListener());
        EventUtils.registerEvent(new FlagVehicleDestroyListener());
        EventUtils.registerEvent(new FlagExplosionDamageListener());
        EventUtils.registerEvent(new FlagExplosionDestroyListener());
        EventUtils.registerEvent(new FlagMobSpawnListener());
        EventUtils.registerEvent(new FlagMobPveListener());
        EventUtils.registerEvent(new FlagMobDamageListener());
        EventUtils.registerEvent(new FlagMobDropListener());
        EventUtils.registerEvent(new FlagMobInteractListener());
        EventUtils.registerEvent(new FlagCommandListener());
        EventUtils.registerEvent(new FlagSendChatListener());
        EventUtils.registerEvent(new FlagIceMeltListener());
        EventUtils.registerEvent(new FlagVinesGrowthListener());
        EventUtils.registerEvent(new FlagExitListener());
        EventUtils.registerEvent(new FlagFarewellListener());
        EventUtils.registerEvent(new FlagGreetingListener());
        EventUtils.registerEvent(new FlagTrampleListener());
        EventUtils.registerEvent(new FlagShulkerBoxesListener());
        EventUtils.registerEvent(new FlagPistonsListener());
        EventUtils.registerEvent(new FlagFrostWalkerListener());
        EventUtils.registerEvent(new FlagFishingPoleListener());
        EventUtils.registerEvent(new FlagItemUseListener());
        EventUtils.registerEvent(new EventPlayerJoin());
        EventUtils.registerEvent(new FlagBlockUseListener());
        Task.builder().execute((Runnable)new FlagHungerListener()).interval((long)HUNGER_TIMER, TimeUnit.SECONDS).name("Hunger Timer Task").submit((Object)INSTANCE);
        Task.builder().execute((Runnable)new FlagGamemodeListener()).interval((long)GAMEMODE_TIMER, TimeUnit.SECONDS).name("Gamemode Timer Task").submit((Object)INSTANCE);
        Task.builder().execute((Runnable)new FlagEnterListener()).interval((long)ENTER_FLAG_TIMER, TimeUnit.MILLISECONDS).name("Enter Flag Timer Task").submit((Object)INSTANCE);
        if (USE_EFFECTS) {
            Task.builder().execute((Runnable)new FlagEffectListener()).interval((long)EFFECT_TIMER, TimeUnit.MILLISECONDS).name("Effect Flag Timer Task").submit((Object)INSTANCE);
        }
    }

    static {
        SELECTOR_ITEM = ItemTypes.STICK;
    }
}

