/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.power.energy.PublicEnergyWrapper;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class TileMachineProvider
extends TileMachine {
    PublicEnergyWrapper.Extract extract;

    public TileMachineProvider() {
        this.extract = new PublicEnergyWrapper.Extract((IEnergyStorage)this.storage);
    }

    @Override
    public void process() {
        switch ((RedstoneState)((Object)this.redstone_state.value)) {
            case OPERATE_REDSTONE_ON: {
                if (this.powered.value) break;
                this.setInactive();
                return;
            }
            case OPERATE_REDSTONE_OFF: {
                if (!this.powered.value) break;
                this.setInactive();
                return;
            }
            case OPERATE_REDSTONE_PULSE: {
                if (this.pulses.value != 0) break;
                this.setInactive();
                return;
            }
        }
        this.sendEnergy();
        if (!this.active || this.machine.getRunError(this.field_145850_b, this.field_174879_c, this, this.speed) != null) {
            this.setInactive();
            return;
        }
        int n = 1 + this.upgrades.getLevel(Upgrade.SPEED);
        for (int i = 0; i < n; ++i) {
            if (this.totalTime > 0) {
                int energyAtTime1 = (int)((float)this.energyOutput * this.processTime / (float)this.totalTime);
                int energyAtTime2 = (int)((float)this.energyOutput * Math.min((float)this.totalTime, this.processTime + this.speed) / (float)this.totalTime);
                if (!this.processEnergy(energyAtTime2 - energyAtTime1)) {
                    this.setInactive();
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        this.processTime += 1.0f;
                        if (this.processTime >= (float)this.totalTime) {
                            this.processTime = 0.0f;
                            this.totalTime = 0;
                            this.energyOutput = 0;
                        }
                    }
                    return;
                }
                this.setActive();
                if (i == 0) {
                    this.machine.processingTick(this, this.curRecipe, this.processTime, n);
                }
                this.processTime += this.speed;
                if (!(this.processTime >= (float)this.totalTime)) continue;
                this.processTime = 0.0f;
                this.totalTime = 0;
                this.energyOutput = 0;
                continue;
            }
            this.processRecipeInput();
            if (this.curRecipe == null) {
                this.setInactive();
                return;
            }
            this.totalTime = this.curRecipe.getProcessingTime(this.itemInputMap, this.fluidInputMap);
            this.energyOutput = this.curRecipe.getEnergyOutput(this.itemInputMap, this.fluidInputMap);
            this.processTime = 0.0f;
            if (this.totalTime == 0 && !this.processEnergy(this.energyOutput)) {
                this.setInactive();
                return;
            }
            this.setActive();
            this.consumeInputs();
            if (this.pulses.value <= 0) continue;
            --this.pulses.value;
        }
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.machine != null ? this.extract : null;
    }

    public void sendEnergy() {
        if (this.storage.getEnergyStored() <= 0) {
            return;
        }
        int maxSend = Math.min(this.machine.energyTransferLimit * (1 + this.upgrades.getLevel(Upgrade.SPEED)), this.storage.getEnergyStored());
        if (maxSend <= 0) {
            return;
        }
        boolean sent = false;
        LinkedHashSet<IEnergyStorage> receivers = new LinkedHashSet<IEnergyStorage>();
        for (EnumFacing facing : FacingHelper.randOrders[this.field_145850_b.field_73012_v.nextInt(12)]) {
            IEnergyStorage storage;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity == null || (storage = CapGetter.energyReceiver.getInterface((ICapabilityProvider)tileEntity, facing.func_176734_d())) == null) continue;
            receivers.add(storage);
        }
        if (receivers.isEmpty()) {
            return;
        }
        int toSend = maxSend / receivers.size();
        if (toSend > 0) {
            for (IEnergyStorage receiver : receivers) {
                int energy = receiver.receiveEnergy(toSend, false);
                this.storage.modifyEnergyStored(-energy);
                if ((maxSend -= energy) > 0) continue;
                break;
            }
        }
        for (IEnergyStorage receiver : receivers) {
            int energy = receiver.receiveEnergy(maxSend, false);
            this.storage.modifyEnergyStored(-energy);
            if ((maxSend -= energy) > 0) continue;
            break;
        }
        this.func_70296_d();
    }

    protected boolean processEnergy(int amount) {
        if (amount == 0) {
            return true;
        }
        int curStored = this.storage.receiveEnergy(amount, true);
        if (curStored == amount) {
            this.storage.receiveEnergy(amount, false);
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74768_a("TotalTime", this.totalTime);
        nbt.func_74768_a("EnergyOutput", this.energyOutput);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.totalTime = nbt.func_74762_e("TotalTime");
        this.energyOutput = nbt.func_74762_e("EnergyOutput");
    }
}

