/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.common.golems.seals.SealHandler;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.world.aura.AuraHandler;

@Mod.EventBusSubscriber
public class WorldEvents {
    public static WorldEvents INSTANCE = new WorldEvents();

    @SubscribeEvent
    public static void worldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            AuraHandler.addAuraWorld(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public static void worldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        SealHandler.sealEntities.remove(event.getWorld().field_73011_w.getDimension());
        AuraHandler.removeAuraWorld(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void placeBlockEvent(BlockEvent.PlaceEvent event) {
        if (WorldEvents.isNearActiveBoss(event.getWorld(), event.getPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void placeBlockEvent(BlockEvent.MultiPlaceEvent event) {
        if (WorldEvents.isNearActiveBoss(event.getWorld(), event.getPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) {
            event.setCanceled(true);
        }
    }

    private static boolean isNearActiveBoss(World world, EntityPlayer player, int x, int y, int z) {
        return false;
    }

    @SubscribeEvent
    public static void noteEvent(NoteBlockEvent.Play event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!TileArcaneEar.noteBlockEvents.containsKey(event.getWorld().field_73011_w.getDimension())) {
            TileArcaneEar.noteBlockEvents.put(event.getWorld().field_73011_w.getDimension(), new ArrayList());
        }
        ArrayList<Integer[]> list = TileArcaneEar.noteBlockEvents.get(event.getWorld().field_73011_w.getDimension());
        list.add(new Integer[]{event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), event.getInstrument().ordinal(), event.getVanillaNoteId()});
        TileArcaneEar.noteBlockEvents.put(event.getWorld().field_73011_w.getDimension(), list);
    }
}

