/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.gui.containers.ContainerPrinter;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;

public class TileEntityPrinter
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[]{1};
    public int printerPrintTime;
    public int currentItemPrintTime;
    public int printingTime;
    public int totalCookTime;

    public TileEntityPrinter() {
        super("printer", 3);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.printerPrintTime = tagCompound.func_74765_d("BurnTime");
        this.printingTime = tagCompound.func_74765_d("CookTime");
        this.totalCookTime = tagCompound.func_74765_d("CookTimeTotal");
        this.currentItemPrintTime = tagCompound.func_74762_e("CurrentTimePrintTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.printerPrintTime);
        tagCompound.func_74777_a("CookTime", (short)this.printingTime);
        tagCompound.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        tagCompound.func_74768_a("CurrentTimePrintTime", this.currentItemPrintTime);
        return tagCompound;
    }

    public boolean isPrinting() {
        return this.printerPrintTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.printingTime > 0;
        boolean flag1 = false;
        if (this.isPrinting()) {
            --this.printerPrintTime;
        }
        if (!this.isPrinting() && (this.func_70301_a(1).func_190926_b() || this.func_70301_a(0).func_190926_b())) {
            if (!this.isPrinting() && this.printingTime > 0) {
                this.printingTime = MathHelper.func_76125_a((int)(this.printingTime - 2), (int)0, (int)this.totalCookTime);
            }
        } else {
            if (!this.isPrinting() && this.canPrint()) {
                this.currentItemPrintTime = this.printerPrintTime = TileEntityPrinter.getItemPrintTime(this.func_70301_a(1));
                this.totalCookTime = this.getPrintTime(this.func_70301_a(0));
                if (this.isPrinting()) {
                    flag1 = true;
                    if (!this.func_70301_a(1).func_190926_b()) {
                        this.func_70301_a(1).func_190918_g(1);
                        if (this.func_70301_a(1).func_190916_E() == 0) {
                            this.func_70299_a(1, this.func_70301_a(1).func_77973_b().getContainerItem(this.func_70301_a(1)));
                        }
                    }
                }
            }
            if (this.isPrinting() && this.canPrint()) {
                ++this.printingTime;
                if (!flag) {
                    TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
                }
                if (this.printingTime == this.totalCookTime) {
                    this.printingTime = 0;
                    this.printItem();
                    flag1 = true;
                }
            } else {
                this.printingTime = 0;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (flag && this.printingTime == 0) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public int getPrintTime(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151134_bR) {
            return 10000;
        }
        return 1000;
    }

    private boolean canPrint() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        if (RecipeAPI.getPrinterRecipeFromInput(this.func_70301_a(0)) != null) {
            return this.func_70301_a(2).func_190926_b();
        }
        return false;
    }

    public void printItem() {
        if (this.canPrint()) {
            ItemStack stack = this.func_70301_a(0);
            if (this.func_70301_a(2).func_190926_b()) {
                this.func_70299_a(2, stack.func_77946_l());
            }
        }
    }

    public static int getItemPrintTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item i = stack.func_77973_b();
        if (stack.func_77952_i() == 0) {
            if (i == Items.field_151100_aR) {
                return 1000;
            }
            if (i == FurnitureItems.INK_CARTRIDGE) {
                return 5000;
            }
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityPrinter.getItemPrintTime(stack) > 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.printerPrintTime;
            }
            case 1: {
                return this.currentItemPrintTime;
            }
            case 2: {
                return this.printingTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.printerPrintTime = value;
                break;
            }
            case 1: {
                this.currentItemPrintTime = value;
                break;
            }
            case 2: {
                this.printingTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntityPrinter.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerPrinter((IInventory)playerInventory, this);
    }
}

