/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.items;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureItems;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCup
extends Item {
    private boolean hasLiquid = false;

    public ItemCup(boolean hasLiquid) {
        this.hasLiquid = hasLiquid;
        if (hasLiquid) {
            this.func_77625_d(1);
        } else {
            this.func_77637_a(MrCrayfishFurnitureMod.tabFurniture);
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("Name", 8)) {
            return nbt.func_74779_i("Name");
        }
        return super.func_77653_i(stack);
    }

    public ItemStack func_77654_b(ItemStack cup, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.hasLiquid) {
                int heal = cup.func_77978_p().func_74762_e("HealAmount");
                player.func_71024_bL().func_75122_a(heal, 0.5f);
                return new ItemStack(FurnitureItems.CUP);
            }
        }
        return cup;
    }

    public int func_77626_a(ItemStack cup) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (this.hasLiquid && playerIn.func_71024_bL().func_75121_c()) {
            playerIn.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(FurnitureBlocks.CUP, pos, false, facing, (Entity)null)) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = FurnitureBlocks.CUP.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromCompound(ItemStack cup) {
        if (cup.func_77942_o() && cup.func_77978_p().func_74764_b("Colour")) {
            int[] colour = cup.func_77978_p().func_74759_k("Colour");
            Color color = new Color(colour[0], colour[1], colour[2]);
            return color.getRGB();
        }
        return 0xFFFFFF;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == FurnitureBlocks.CUP) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            FurnitureBlocks.CUP.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

