/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockCurtainsClosed;
import com.mrcrayfish.furniture.blocks.BlockCurtainsOpen;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCurtains
extends BlockFurniture {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};

    public BlockCurtains(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        if (!this.isOpen()) {
            this.func_149713_g(255);
        } else {
            this.func_149713_g(0);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_BLINDS_OR_CURTAINS, (EntityPlayer)placer);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX[facing.func_176736_b()]);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isOpen()) {
            return worldIn.func_175656_a(pos, FurnitureBlocks.CURTAINS_CLOSED.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
        return worldIn.func_175656_a(pos, FurnitureBlocks.CURTAINS.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.isOpen()) {
            boolean right_closed;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            IBlockState left_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
            IBlockState right_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
            boolean left_open = left_block.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)left_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean right_open = right_block.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)right_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean left_closed = left_block.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)left_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean bl = right_closed = right_block.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)right_block.func_177229_b((IProperty)FACING)).equals((Object)facing);
            if (right_open) {
                if (left_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.NONE));
                }
                if (left_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT_OPEN));
            }
            if (left_open) {
                if (right_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.NONE));
                }
                if (right_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_OPEN));
            }
            if (right_closed) {
                if (left_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (left_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.RIGHT));
            }
            if (left_closed) {
                if (right_closed) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (right_open) {
                    return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.LEFT));
            }
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.DEFAULT));
        }
        return state;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.CURTAINS_CLOSED).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.CURTAINS_CLOSED);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.isOpen() ? new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE}) : super.func_180661_e();
    }

    public abstract boolean isOpen();

    public static enum Type implements IStringSerializable
    {
        DEFAULT,
        LEFT,
        RIGHT,
        LEFT_OPEN,
        RIGHT_OPEN,
        LEFT_CLOSED,
        RIGHT_CLOSED,
        BOTH,
        NONE;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

