/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.model.ModelVariantContainer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class AdvertSelectionMessage
implements IMalisisMessageHandler<Packet<? extends AdvertModel.IModelVariant>, IMessage> {
    public AdvertSelectionMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, AdvertSelectionMessage.getPacketClass(), Side.SERVER);
    }

    private static Class<Packet<? extends AdvertModel.IModelVariant>> getPacketClass() {
        return new Packet().getClass();
    }

    public void process(Packet<? extends AdvertModel.IModelVariant> message, MessageContext ctx) {
        World world = IMalisisMessageHandler.getWorld((MessageContext)ctx);
        AdvertTileEntity te = (AdvertTileEntity)((Object)TileEntityUtils.getTileEntity(AdvertTileEntity.class, (IBlockAccess)world, (BlockPos)((Packet)message).pos));
        if (te == null) {
            return;
        }
        te.setModelContainer(((Packet)message).container);
        te.addSelections(((Packet)message).selections);
    }

    public static <T extends AdvertModel.IModelVariant> void saveSelection(AdvertTileEntity tileEntity, ModelVariantContainer<T> container, AdvertSelection[] selections) {
        Packet<T> packet = new Packet<T>(tileEntity, container, selections);
        MalisisAdvert.network.sendToServer(packet);
    }

    public static class Packet<T extends AdvertModel.IModelVariant>
    implements IMessage {
        private BlockPos pos;
        private ModelVariantContainer<T> container;
        private AdvertSelection[] selections = new AdvertSelection[0];

        public Packet() {
        }

        public Packet(AdvertTileEntity tileEntity, ModelVariantContainer<T> container, AdvertSelection[] selections) {
            this.pos = tileEntity.func_174877_v();
            this.container = container;
            this.selections = selections;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.container = ModelVariantContainer.fromBytes(buf);
            this.selections = new AdvertSelection[this.container.getModel().getAvailableSlots()];
            while (buf.isReadable()) {
                this.selections[buf.readByte()] = AdvertSelection.fromBytes(buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            this.container.toBytes(buf);
            for (int i = 0; i < this.selections.length; ++i) {
                if (this.selections[i] == null) continue;
                buf.writeByte(i);
                this.selections[i].toBytes(buf);
            }
        }
    }
}

