/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.processor.generator.ChunkThread;

public enum ChunkLogger {
    Chunks("TaskList", true){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append(process.processed + "/" + process.currentTask.getTotalWorkList() + " Chunks");
        }
    }
    ,
    Position("CurrentPosition", true){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("<Pos: " + pos.x + ", " + pos.z + ">");
        }
    }
    ,
    AverageGen("Generation-Speed", true){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("<Average/t: " + ChunkProcessor.format.format(process.counter.getAverage()) + ">");
        }
    }
    ,
    AverageLag("CPU-Usage", false){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("<Average Lag: " + ChunkProcessor.format.format(process.timer.getAverageDelta()) + "MS>");
        }
    }
    ,
    LoadedChunks("Loaded-Chunks", false){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("<Loaded Chunks: " + process.getLoadedChunks() + ">");
        }
    }
    ,
    LoadedRegionFiles("Loaded-Files", false){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("<Loaded Files: " + ChunkThread.getLoadedFiles() + ">");
        }
    }
    ,
    ExpectedTime("ExpectedTime", false){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            int total = process.currentTask.getTotalWorkList();
            long left = (long)((float)(total - process.processed) / process.counter.getAverage());
            long expected = left * process.timer.getAverageDelta();
            builder.append("<Expected Time: " + process.formatIntoTime(expected) + ">");
        }
    }
    ,
    Ram("RamUsage", true){

        @Override
        public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
            builder.append("Ram: " + process.getRamUsage() + "MB");
        }
    };

    boolean theDefault;
    String ID;
    static Map<String, ChunkLogger> loggerInfo;

    private ChunkLogger(String visibleName, boolean pre) {
        this.ID = visibleName;
        this.theDefault = pre;
    }

    public String getName() {
        return this.ID;
    }

    public boolean getDefault() {
        return this.theDefault;
    }

    public static ChunkLogger byID(String id) {
        return loggerInfo.get(id);
    }

    public static List<String> getNames() {
        return new ArrayList<String>(loggerInfo.keySet());
    }

    public static List<ChunkLogger> getLoggers() {
        return new ArrayList<ChunkLogger>(loggerInfo.values());
    }

    public void addPreLog(StringBuilder builder, ChunkProcessor process, FilePos pos) {
    }

    static {
        loggerInfo = new LinkedHashMap<String, ChunkLogger>();
        for (ChunkLogger info : ChunkLogger.values()) {
            loggerInfo.put(info.getName(), info);
        }
    }
}

