/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.gui;

import info.loenwind.autoconfig.gui.ConfigElementProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ConfigElementCategory
implements IConfigElement {
    private ConfigCategory category;

    public ConfigElementCategory(ConfigCategory category) {
        this.category = category;
    }

    public List<IConfigElement> getChildElements() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (ConfigCategory subcat : this.category.getChildren()) {
            if (!subcat.showInGui()) continue;
            elements.add(new ConfigElementCategory(subcat));
        }
        for (Property element : this.category.getOrderedValues()) {
            if (!element.showInGui()) continue;
            elements.add(new ConfigElementProperty(element));
        }
        return elements;
    }

    @Nullable
    public String getName() {
        return this.category.getName();
    }

    public boolean isProperty() {
        return false;
    }

    @Nullable
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.category.getConfigEntryClass();
    }

    @Nullable
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return null;
    }

    @Nullable
    public String getQualifiedName() {
        return this.category.getQualifiedName();
    }

    public ConfigGuiType getType() {
        return ConfigGuiType.CONFIG_CATEGORY;
    }

    public static ConfigGuiType getType(Property prop) {
        switch (prop.getType()) {
            case BOOLEAN: {
                return ConfigGuiType.BOOLEAN;
            }
            case COLOR: {
                return ConfigGuiType.COLOR;
            }
            case DOUBLE: {
                return ConfigGuiType.DOUBLE;
            }
            case INTEGER: {
                return ConfigGuiType.INTEGER;
            }
            case MOD_ID: {
                return ConfigGuiType.MOD_ID;
            }
        }
        return ConfigGuiType.STRING;
    }

    public boolean isList() {
        return false;
    }

    public boolean isListLengthFixed() {
        return false;
    }

    public int getMaxListLength() {
        return -1;
    }

    @Nullable
    public String getComment() {
        return this.category.getComment();
    }

    public boolean isDefault() {
        return true;
    }

    public void setToDefault() {
    }

    public boolean requiresWorldRestart() {
        return this.category.requiresWorldRestart();
    }

    public boolean showInGui() {
        return this.category.showInGui();
    }

    public boolean requiresMcRestart() {
        return this.category.requiresMcRestart();
    }

    @Nullable
    public String[] getValidValues() {
        return null;
    }

    @Nullable
    public String getLanguageKey() {
        return this.category.getLanguagekey();
    }

    @Nullable
    public Object getDefault() {
        return null;
    }

    @Nullable
    public Object[] getDefaults() {
        return null;
    }

    @Nullable
    public Pattern getValidationPattern() {
        return null;
    }

    @Nullable
    public Object get() {
        return null;
    }

    @Nullable
    public Object[] getList() {
        return null;
    }

    public void set(@Nullable Object value) {
    }

    public void set(@Nullable Object[] aVal) {
    }

    @Nullable
    public Object getMinValue() {
        return null;
    }

    @Nullable
    public Object getMaxValue() {
        return null;
    }
}

