/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api7;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.ProxiedServiceObject;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;

public final class SubjectCollectionProxy
implements SubjectCollection,
ProxiedServiceObject {
    private final LPSubjectCollection handle;

    public SubjectCollectionProxy(LPSubjectCollection handle) {
        this.handle = handle;
    }

    public @NonNull String getIdentifier() {
        return this.handle.getIdentifier();
    }

    public @NonNull Predicate<String> getIdentifierValidityPredicate() {
        return this.handle.getIdentifierValidityPredicate();
    }

    public @NonNull CompletableFuture<Subject> loadSubject(@NonNull String s) {
        return this.handle.loadSubject(s).thenApply(LPSubject::sponge);
    }

    public @NonNull Optional<Subject> getSubject(@NonNull String s) {
        return this.handle.getSubject(s).map(LPSubject::sponge);
    }

    public @NonNull CompletableFuture<Boolean> hasSubject(@NonNull String s) {
        return this.handle.hasRegistered(s);
    }

    public @NonNull CompletableFuture<Map<String, Subject>> loadSubjects(@NonNull Set<String> set) {
        return this.handle.loadSubjects(set).thenApply(subs -> (Map)subs.stream().collect(ImmutableCollectors.toMap(LPSubject::getIdentifier, LPSubject::sponge)));
    }

    public @NonNull Collection<Subject> getLoadedSubjects() {
        return (Collection)this.handle.getLoadedSubjects().stream().map(LPSubject::sponge).collect(ImmutableCollectors.toSet());
    }

    public @NonNull CompletableFuture<Set<String>> getAllIdentifiers() {
        return this.handle.getAllIdentifiers();
    }

    public @NonNull SubjectReference newSubjectReference(@NonNull String subjectIdentifier) {
        Objects.requireNonNull(subjectIdentifier, "identifier");
        if (!this.handle.getIdentifierValidityPredicate().test(subjectIdentifier)) {
            throw new IllegalArgumentException("Subject identifier '" + subjectIdentifier + "' does not pass the validity predicate");
        }
        return this.handle.getService().getReferenceFactory().obtain(this.getIdentifier(), subjectIdentifier);
    }

    public @NonNull CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@NonNull String s) {
        return this.handle.getAllWithPermission(s);
    }

    public @NonNull CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@NonNull Set<Context> set, @NonNull String s) {
        return this.handle.getAllWithPermission(CompatibilityUtil.convertContexts(set), s);
    }

    public @NonNull Map<Subject, Boolean> getLoadedWithPermission(@NonNull String s) {
        return (Map)this.handle.getLoadedWithPermission(s).entrySet().stream().collect(ImmutableCollectors.toMap(sub -> ((LPSubject)sub.getKey()).sponge(), Map.Entry::getValue));
    }

    public @NonNull Map<Subject, Boolean> getLoadedWithPermission(@NonNull Set<Context> set, @NonNull String s) {
        return (Map)this.handle.getLoadedWithPermission(CompatibilityUtil.convertContexts(set), s).entrySet().stream().collect(ImmutableCollectors.toMap(sub -> ((LPSubject)sub.getKey()).sponge(), Map.Entry::getValue));
    }

    public @NonNull Subject getDefaults() {
        return this.handle.getDefaults().sponge();
    }

    public void suggestUnload(@NonNull String s) {
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SubjectCollectionProxy && this.handle.equals(((SubjectCollectionProxy)o).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "luckperms.api7.SubjectCollectionProxy(handle=" + this.handle + ")";
    }
}

