/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.query.QueryOptions;

public class WebEditorRequest {
    public static final int MAX_USERS = 500;
    private final JsonObject payload;

    public static WebEditorRequest generate(List<PermissionHolder> holders, List<Track> tracks, Sender sender, String cmdLabel, LuckPermsPlugin plugin) {
        Preconditions.checkArgument((!holders.isEmpty() ? 1 : 0) != 0, (Object)"holders is empty");
        ImmutableContextSetImpl.BuilderImpl potentialContexts = new ImmutableContextSetImpl.BuilderImpl();
        potentialContexts.addAll(plugin.getContextManager().getPotentialContexts());
        for (PermissionHolder holder : holders) {
            holder.normalData().forEach(node -> potentialContexts.addAll(node.getContexts()));
        }
        return new WebEditorRequest(holders, tracks, sender, cmdLabel, potentialContexts.build(), plugin);
    }

    private WebEditorRequest(List<PermissionHolder> holders, List<Track> tracks, Sender sender, String cmdLabel, ImmutableContextSet potentialContexts, LuckPermsPlugin plugin) {
        this.payload = new JObject().add("metadata", WebEditorRequest.formMetadata(sender, cmdLabel, plugin.getBootstrap().getVersion())).add("permissionHolders", new JArray().consume(arr -> {
            for (PermissionHolder holder : holders) {
                arr.add(WebEditorRequest.formPermissionHolder(holder));
            }
        })).add("tracks", new JArray().consume(arr -> {
            for (Track track : tracks) {
                arr.add(WebEditorRequest.formTrack(track));
            }
        })).add("knownPermissions", new JArray().addAll(plugin.getPermissionRegistry().rootAsList())).add("potentialContexts", (JsonElement)ContextSetJsonSerializer.serialize(potentialContexts)).toJson();
    }

    private static JObject formMetadata(Sender sender, String cmdLabel, String pluginVersion) {
        return new JObject().add("commandAlias", cmdLabel).add("uploader", new JObject().add("name", sender.getNameWithLocation()).add("uuid", sender.getUniqueId().toString())).add("time", System.currentTimeMillis()).add("pluginVersion", pluginVersion);
    }

    private static JObject formPermissionHolder(PermissionHolder holder) {
        return new JObject().add("type", holder.getType().toString()).add("id", holder.getObjectName()).add("displayName", holder.getPlainDisplayName()).add("nodes", (JsonElement)NodeJsonSerializer.serializeNodes(holder.normalData().asList()));
    }

    private static JObject formTrack(Track track) {
        return new JObject().add("type", "track").add("id", track.getName()).add("groups", new JArray().addAll(track.getGroups()));
    }

    public byte[] encode() {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.normal().toJson((JsonElement)this.payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytesOut.toByteArray();
    }

    public CommandResult createSession(LuckPermsPlugin plugin, Sender sender) {
        String pasteId;
        try {
            pasteId = plugin.getBytebin().postContent(this.encode(), AbstractHttpClient.JSON_TYPE).key();
        }
        catch (UnsuccessfulRequestException e) {
            Message.EDITOR_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
            return CommandResult.STATE_ERROR;
        }
        catch (IOException e) {
            new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
            Message.EDITOR_HTTP_UNKNOWN_FAILURE.send(sender);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.WEB_EDITOR_URL_PATTERN) + pasteId;
        Message.EDITOR_URL.send(sender, url);
        return CommandResult.SUCCESS;
    }

    public static void includeMatchingGroups(List<? super Group> holders, Predicate<? super Group> filter, LuckPermsPlugin plugin) {
        plugin.getGroupManager().getAll().values().stream().filter(filter).sorted(Comparator.comparingInt(g -> g.getWeight().orElse(0)).reversed().thenComparing(Group::getName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
    }

    public static void includeMatchingUsers(List<? super User> holders, ConstraintNodeMatcher<Node> matcher, boolean includeOffline, LuckPermsPlugin plugin) {
        WebEditorRequest.includeMatchingUsers(holders, matcher == null ? Collections.emptyList() : Collections.singleton(matcher), includeOffline, plugin);
    }

    public static void includeMatchingUsers(List<? super User> holders, Collection<ConstraintNodeMatcher<Node>> matchers, boolean includeOffline, LuckPermsPlugin plugin) {
        LinkedHashMap<UUID, User> users = new LinkedHashMap<UUID, User>(plugin.getUserManager().getAll());
        if (!matchers.isEmpty()) {
            users.values().removeIf(user -> {
                for (ConstraintNodeMatcher matcher : matchers) {
                    if (!user.normalData().asList().stream().anyMatch(matcher)) continue;
                    return false;
                }
                return true;
            });
        }
        if (includeOffline && users.size() < 500) {
            if (matchers.isEmpty()) {
                WebEditorRequest.findMatchingOfflineUsers(users, null, plugin);
            } else {
                for (ConstraintNodeMatcher<Node> matcher : matchers) {
                    if (users.size() >= 500) break;
                    WebEditorRequest.findMatchingOfflineUsers(users, matcher, plugin);
                }
            }
        }
        users.values().stream().sorted(Comparator.comparingInt(u -> u.getCachedData().getMetaData(QueryOptions.nonContextual()).getWeight(MetaCheckEvent.Origin.INTERNAL)).reversed().thenComparing(u -> u.getUsername().isPresent(), ((Comparator)Boolean::compare).reversed()).thenComparing(User::getPlainDisplayName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
    }

    private static void findMatchingOfflineUsers(Map<UUID, User> users, ConstraintNodeMatcher<Node> matcher, LuckPermsPlugin plugin) {
        Stream<Object> stream = matcher == null ? plugin.getStorage().getUniqueUsers().join().stream() : plugin.getStorage().searchUserNodes(matcher).join().stream().map(NodeEntry::getHolder).distinct();
        stream.filter(uuid -> !users.containsKey(uuid)).sorted().limit(500 - users.size()).forEach(uuid -> {
            User user = plugin.getStorage().loadUser((UUID)uuid, null).join();
            if (user != null) {
                users.put((UUID)uuid, user);
            }
            plugin.getUserManager().getHouseKeeper().cleanup((UUID)uuid);
        });
    }
}

