/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.lucko.luckperms.common.util.gson.JElement;

public class JArray
implements JElement {
    private final JsonArray array = new JsonArray();

    public JsonArray toJson() {
        return this.array;
    }

    public JArray add(JsonElement value) {
        if (value == null) {
            return this.add((JsonElement)JsonNull.INSTANCE);
        }
        this.array.add(value);
        return this;
    }

    public JArray add(String value) {
        if (value == null) {
            return this.add((JsonElement)JsonNull.INSTANCE);
        }
        this.array.add((JsonElement)new JsonPrimitive(value));
        return this;
    }

    public JArray addAll(Iterable<String> iterable) {
        for (String s : iterable) {
            this.add(s);
        }
        return this;
    }

    public JArray add(JElement value) {
        if (value == null) {
            return this.add((JsonElement)JsonNull.INSTANCE);
        }
        return this.add(value.toJson());
    }

    public JArray add(Supplier<? extends JElement> value) {
        return this.add(value.get().toJson());
    }

    public JArray consume(Consumer<? super JArray> consumer) {
        consumer.accept(this);
        return this;
    }
}

