/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.util.Map;
import java.util.function.Function;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public class PostgreConnectionFactory
extends HikariConnectionFactory {
    public PostgreConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    @Override
    public String getImplementationName() {
        return "PostgreSQL";
    }

    @Override
    protected String defaultPort() {
        return "5432";
    }

    @Override
    protected void configureDatabase(HikariConfig config, String address, String port, String databaseName, String username, String password) {
        config.setDataSourceClassName("me.lucko.luckperms.lib.postgresql.ds.PGSimpleDataSource");
        config.addDataSourceProperty("serverName", (Object)address);
        config.addDataSourceProperty("portNumber", (Object)port);
        config.addDataSourceProperty("databaseName", (Object)databaseName);
        config.addDataSourceProperty("user", (Object)username);
        config.addDataSourceProperty("password", (Object)password);
    }

    @Override
    protected void overrideProperties(Map<String, String> properties) {
        super.overrideProperties(properties);
        properties.remove("useUnicode");
        properties.remove("characterEncoding");
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace('\'', '\"');
    }
}

