/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cache.ExpiringCache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ForwardingContextCalculator;
import me.lucko.luckperms.common.context.QueryOptionsSupplier;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.StaticContextCalculator;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ContextManager<S, P extends S> {
    protected final LuckPermsPlugin plugin;
    private final Class<S> subjectClass;
    private final Class<P> playerClass;
    private final CalculatorList calculators = new CalculatorList();
    private final StaticLookupCache staticLookupCache = new StaticLookupCache();

    protected ContextManager(LuckPermsPlugin plugin, Class<S> subjectClass, Class<P> playerClass) {
        this.plugin = plugin;
        this.subjectClass = subjectClass;
        this.playerClass = playerClass;
    }

    public Class<S> getSubjectClass() {
        return this.subjectClass;
    }

    public Class<P> getPlayerClass() {
        return this.playerClass;
    }

    public abstract UUID getUniqueId(P var1);

    public abstract QueryOptionsSupplier getCacheFor(S var1);

    public QueryOptions getQueryOptions(S subject) {
        return this.getCacheFor(subject).getQueryOptions();
    }

    public ImmutableContextSet getContext(S subject) {
        return this.getCacheFor(subject).getContextSet();
    }

    public QueryOptions getStaticQueryOptions() {
        return (QueryOptions)this.staticLookupCache.get();
    }

    public ImmutableContextSet getStaticContext() {
        return this.getStaticQueryOptions().context();
    }

    public QueryOptions formQueryOptions(ImmutableContextSet contextSet) {
        return this.plugin.getConfiguration().get(ConfigKeys.GLOBAL_QUERY_OPTIONS).toBuilder().context(contextSet).build();
    }

    public abstract QueryOptions formQueryOptions(S var1, ImmutableContextSet var2);

    public void signalContextUpdate(S subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        this.invalidateCache(subject);
        this.plugin.getEventDispatcher().dispatchContextUpdate(subject);
    }

    protected abstract void invalidateCache(S var1);

    public void registerCalculator(ContextCalculator<? super S> calculator) {
        this.calculators.add(calculator);
    }

    public void unregisterCalculator(ContextCalculator<? super S> calculator) {
        this.calculators.remove(calculator);
    }

    protected QueryOptions calculate(S subject) {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        ContextConsumer consumer = accumulator::add;
        for (ContextCalculator contextCalculator : this.calculators.calculators()) {
            try {
                contextCalculator.calculate(subject, consumer);
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(contextCalculator) + " whilst calculating the context of subject " + subject, e);
            }
        }
        return this.formQueryOptions(subject, accumulator.build());
    }

    private QueryOptions calculateStatic() {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        ContextConsumer consumer = accumulator::add;
        for (StaticContextCalculator calculator : this.calculators.staticCalculators()) {
            try {
                calculator.calculate(consumer);
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating static contexts", e);
            }
        }
        return this.formQueryOptions(accumulator.build());
    }

    public ImmutableContextSet getPotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (ContextCalculator contextCalculator : this.calculators.calculators()) {
            ContextSet potentialContexts;
            try {
                potentialContexts = contextCalculator.estimatePotentialContexts();
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(contextCalculator) + " whilst estimating potential contexts", e);
                continue;
            }
            builder.addAll(potentialContexts);
        }
        return builder.build();
    }

    private static String getCalculatorClass(ContextCalculator<?> calculator) {
        Class<?> calculatorClass = calculator instanceof ForwardingContextCalculator ? ((ForwardingContextCalculator)calculator).delegate().getClass() : calculator.getClass();
        return calculatorClass.getName();
    }

    private final class CalculatorList {
        private final List<ContextCalculator<? super S>> calculators = new ArrayList();
        private final List<StaticContextCalculator> staticCalculators = new ArrayList<StaticContextCalculator>();
        private volatile ContextCalculator<? super S>[] calculatorsArray;
        private volatile StaticContextCalculator[] staticCalculatorsArray;

        CalculatorList() {
            this.bake();
        }

        private void bake() {
            this.calculatorsArray = this.calculators.toArray(new ContextCalculator[0]);
            this.staticCalculatorsArray = this.staticCalculators.toArray(new StaticContextCalculator[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ContextCalculator<? super S> calculator) {
            CalculatorList calculatorList = this;
            synchronized (calculatorList) {
                this.calculators.add(0, calculator);
                if (calculator instanceof StaticContextCalculator) {
                    StaticContextCalculator staticCalculator = (StaticContextCalculator)calculator;
                    this.staticCalculators.add(0, staticCalculator);
                }
                this.bake();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ContextCalculator<? super S> calculator) {
            CalculatorList calculatorList = this;
            synchronized (calculatorList) {
                this.calculators.remove(calculator);
                if (calculator instanceof StaticContextCalculator) {
                    this.staticCalculators.remove(calculator);
                }
                this.bake();
            }
        }

        public ContextCalculator<? super S>[] calculators() {
            return this.calculatorsArray;
        }

        public StaticContextCalculator[] staticCalculators() {
            return this.staticCalculatorsArray;
        }
    }

    private final class StaticLookupCache
    extends ExpiringCache<QueryOptions> {
        StaticLookupCache() {
            super(50L, TimeUnit.MILLISECONDS);
        }

        @Override
        public @NonNull QueryOptions supply() {
            return ContextManager.this.calculateStatic();
        }
    }
}

