/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.permission;

import java.time.Duration;
import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class PermissionUnsetTemp
extends GenericChildCommand {
    public PermissionUnsetTemp() {
        super(CommandSpec.PERMISSION_UNSETTEMP, "unsettemp", CommandPermission.USER_PERM_UNSET_TEMP, CommandPermission.GROUP_PERM_UNSET_TEMP, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        String node = args.get(0);
        Duration duration = args.getDurationOrDefault(1, null);
        int fromIndex = duration == null ? 1 : 2;
        MutableContextSet context = args.getContextOrDefault(fromIndex, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, node)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        Object builtNode = NodeBuilders.determineMostApplicable(node).expiry(10L).withContext(context).build();
        if (builtNode instanceof InheritanceNode && ArgumentPermissions.checkGroup(plugin, sender, ((InheritanceNode)builtNode).getGroupName(), (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        DataMutateResult.WithMergedNode result = target.unsetNode(DataType.NORMAL, (Node)builtNode, duration);
        if (result.getResult().wasSuccessful()) {
            Node mergedNode = result.getMergedNode();
            if (mergedNode != null) {
                Message.UNSET_TEMP_PERMISSION_SUBTRACT_SUCCESS.send(sender, mergedNode.getKey(), mergedNode.getValue(), target, mergedNode.getExpiryDuration(), context, duration);
                LoggedAction.build().source(sender).target(target).description("permission", "unsettemp", node, duration, context).build().submit(plugin, sender);
            } else {
                Message.UNSET_TEMP_PERMISSION_SUCCESS.send(sender, node, target, context);
                LoggedAction.build().source(sender).target(target).description("permission", "unsettemp", node, context).build().submit(plugin, sender);
            }
            StorageAssistant.save(target, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.DOES_NOT_HAVE_TEMP_PERMISSION.send(sender, target, node, context);
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

