/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;

public class NCRenderHelper {
    public static final float PIXEL = 0.0625f;

    public static void renderBlockFrame(BlockPos pos, float r, float g, float b, float a) {
        NCRenderHelper.renderFrame(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0f, 1.0f, 1.0f, r, g, b, a);
    }

    public static void renderCubeFrame(BlockPos pos, float size, float r, float g, float b, float a) {
        NCRenderHelper.renderFrame((float)pos.func_177958_n() + (8.0f - size / 2.0f) * 0.0625f, (float)pos.func_177956_o() + (8.0f - size / 2.0f) * 0.0625f, (float)pos.func_177952_p() + (8.0f - size / 2.0f) * 0.0625f, size * 0.0625f, size * 0.0625f, size * 0.0625f, r, g, b, a);
    }

    public static void renderFrame(float oX, float oY, float oZ, float lX, float lY, float lZ, float r, float g, float b, float a) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        NCRenderHelper.drawLine(buffer, oX, oY, oZ, lX, 0.0f, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY, oZ, 0.0f, lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY, oZ, 0.0f, 0.0f, lZ, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX + lX, oY, oZ, 0.0f, lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX + lX, oY, oZ, 0.0f, 0.0f, lZ, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY + lY, oZ, lX, 0.0f, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY + lY, oZ, 0.0f, 0.0f, lZ, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY, oZ + lZ, lX, 0.0f, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY, oZ + lZ, 0.0f, lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX + lX, oY + lY, oZ, 0.0f, 0.0f, lZ, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX + lX, oY, oZ + lZ, 0.0f, lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawLine(buffer, oX, oY + lY, oZ + lZ, lX, 0.0f, 0.0f, r, g, b, a);
    }

    private static void drawLine(BufferBuilder buffer, float oX, float oY, float oZ, float lX, float lY, float lZ, float r, float g, float b, float a) {
        buffer.func_181662_b((double)oX, (double)oY, (double)oZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(oX + lX), (double)(oY + lY), (double)(oZ + lZ)).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void renderBlockFaces(BlockPos pos, float r, float g, float b, float a) {
        NCRenderHelper.renderFaces(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0f, 1.0f, 1.0f, r, g, b, a);
    }

    public static void renderBlockFaces(BlockPos pos, float size, float r, float g, float b, float a) {
        NCRenderHelper.renderFaces((float)pos.func_177958_n() + (8.0f - size / 2.0f) * 0.0625f, (float)pos.func_177956_o() + (8.0f - size / 2.0f) * 0.0625f, (float)pos.func_177952_p() + (8.0f - size / 2.0f) * 0.0625f, size * 0.0625f, size * 0.0625f, size * 0.0625f, r, g, b, a);
    }

    public static void renderFaces(float oX, float oY, float oZ, float lX, float lY, float lZ, float r, float g, float b, float a) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        NCRenderHelper.drawRect(buffer, oX, oY, oZ, 0.0f, lY, 0.0f, lX, 0.0f, 0.0f, r, g, b, a);
        NCRenderHelper.drawRect(buffer, oX, oY, oZ, 0.0f, 0.0f, lZ, 0.0f, lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawRect(buffer, oX, oY, oZ, lX, 0.0f, 0.0f, 0.0f, 0.0f, lZ, r, g, b, a);
        NCRenderHelper.drawRect(buffer, oX + lX, oY + lY, oZ + lZ, -lX, 0.0f, 0.0f, 0.0f, -lY, 0.0f, r, g, b, a);
        NCRenderHelper.drawRect(buffer, oX + lX, oY + lY, oZ + lZ, 0.0f, 0.0f, -lZ, -lX, 0.0f, 0.0f, r, g, b, a);
        NCRenderHelper.drawRect(buffer, oX + lX, oY + lY, oZ + lZ, 0.0f, -lY, 0.0f, 0.0f, 0.0f, -lZ, r, g, b, a);
    }

    private static void drawRect(BufferBuilder buffer, float oX, float oY, float oZ, float x1, float y1, float z1, float x3, float y3, float z3, float r, float g, float b, float a) {
        buffer.func_181662_b((double)oX, (double)oY, (double)oZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(oX + x1), (double)(oY + y1), (double)(oZ + z1)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(oX + x1 + x3), (double)(oY + y1 + y3), (double)(oZ + z1 + z3)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(oX + x3), (double)(oY + y3), (double)(oZ + z3)).func_181666_a(r, g, b, a).func_181675_d();
    }
}

