/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.energy;

import gregtech.api.capability.IEnergyContainer;
import nc.config.NCConfig;
import nc.tile.energy.ITileEnergy;
import nc.util.EnergyHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="gregtech.api.capability.IEnergyContainer", modid="gregtech")
public class EnergyTileWrapperGT
implements IEnergyContainer {
    public final ITileEnergy tile;
    public final EnumFacing side;

    public EnergyTileWrapperGT(ITileEnergy tile, EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    @Optional.Method(modid="gregtech")
    public long acceptEnergyFromNetwork(EnumFacing sideIn, long voltage, long amperage) {
        if (this.tile.getEnergyStored() >= this.tile.getMaxEnergyStored() || !this.tile.canReceiveEnergy(sideIn)) {
            return 0L;
        }
        long amperesAccepted = Math.min(1L + (long)MathHelper.func_76128_c((double)((double)(this.tile.getMaxEnergyStored() - this.tile.getEnergyStored()) / (double)NCConfig.rf_per_eu)) / voltage, Math.min(amperage, this.getInputAmperage()));
        this.tile.getEnergyStorage().changeEnergyStored((int)Math.min(voltage * amperesAccepted * (long)NCConfig.rf_per_eu, Integer.MAX_VALUE));
        return amperesAccepted;
    }

    @Optional.Method(modid="gregtech")
    public boolean inputsEnergy(EnumFacing sideIn) {
        return this.tile.canReceiveEnergy(sideIn);
    }

    @Optional.Method(modid="gregtech")
    public boolean outputsEnergy(EnumFacing sideIn) {
        return this.tile.canExtractEnergy(sideIn);
    }

    public long changeEnergy(long differenceAmount) {
        int amount = (int)Math.min(differenceAmount, Integer.MAX_VALUE);
        int energyReceived = this.tile.getEnergyStorage().receiveEnergy(NCConfig.rf_per_eu * amount, true);
        this.tile.receiveEnergy(energyReceived, this.side, false);
        return amount - energyReceived / NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="gregtech")
    public long getEnergyStored() {
        return this.tile.getEnergyStored() / NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="gregtech")
    public long getEnergyCapacity() {
        return this.tile.getMaxEnergyStored() / NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="gregtech")
    public long getInputAmperage() {
        return this.tile.getEnergyStored() < this.tile.getMaxEnergyStored() ? 1L : 0L;
    }

    @Optional.Method(modid="gregtech")
    public long getOutputAmperage() {
        return this.tile.getEnergyStored() / NCConfig.rf_per_eu < 1 ? 0L : 1L;
    }

    @Optional.Method(modid="gregtech")
    public long getInputVoltage() {
        return EnergyHelper.getMaxEUFromTier(this.tile.getSinkTier());
    }

    @Optional.Method(modid="gregtech")
    public long getOutputVoltage() {
        return EnergyHelper.getMaxEUFromTier(this.tile.getSourceTier());
    }
}

