/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.block.property.BlockProperties;
import nc.block.tile.IActivatable;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITile {
    public TileEntity getTile();

    public World getTileWorld();

    public BlockPos getTilePos();

    public Block getTileBlockType();

    public int getTileBlockMeta();

    default public EnumFacing getFacingHorizontal() {
        return (EnumFacing)this.getTileBlockType().func_176203_a(this.getTileBlockMeta()).func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL);
    }

    default public IBlockState getBlockState(BlockPos pos) {
        return this.getTileWorld().func_180495_p(pos);
    }

    default public Block getBlock(BlockPos pos) {
        return this.getBlockState(pos).func_177230_c();
    }

    public IRadiationSource getRadiationSource();

    default public boolean shouldSaveRadiation() {
        return true;
    }

    default public void setActivity(boolean isActive) {
        this.setState(isActive, this.getTile());
    }

    @Deprecated
    default public void setState(boolean isActive, TileEntity tile) {
        if (this.getTileBlockType() instanceof IActivatable) {
            ((IActivatable)this.getTileBlockType()).setActivity(isActive, tile);
        }
    }

    default public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        this.refreshIsRedstonePowered(world, pos);
    }

    default public boolean isUsableByPlayer(EntityPlayer player) {
        return player.func_70092_e((double)this.getTilePos().func_177958_n() + 0.5, (double)this.getTilePos().func_177956_o() + 0.5, (double)this.getTilePos().func_177952_p() + 0.5) <= 64.0;
    }

    default public boolean checkIsRedstonePowered(World world, BlockPos pos) {
        return world.func_175640_z(pos) || this.isWeaklyPowered(world, pos);
    }

    default public int[] weakSidesToCheck(World world, BlockPos pos) {
        return new int[0];
    }

    default public boolean isWeaklyPowered(World world, BlockPos pos) {
        for (int i : this.weakSidesToCheck(world, pos)) {
            EnumFacing side = EnumFacing.func_82600_a((int)i);
            BlockPos offPos = pos.func_177972_a(side);
            if (world.func_175651_c(offPos, side) > 0) {
                return true;
            }
            IBlockState state = world.func_180495_p(offPos);
            if (state.func_177230_c() != Blocks.field_150488_af || (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) <= 0) continue;
            return true;
        }
        return false;
    }

    default public void refreshIsRedstonePowered(World world, BlockPos pos) {
        this.setIsRedstonePowered(this.checkIsRedstonePowered(world, pos));
    }

    public boolean getIsRedstonePowered();

    public void setIsRedstonePowered(boolean var1);

    public boolean getAlternateComparator();

    public void setAlternateComparator(boolean var1);

    public boolean getRedstoneControl();

    public void setRedstoneControl(boolean var1);

    public void markTileDirty();

    default public void notifyBlockUpdate() {
        IBlockState state = this.getTileWorld().func_180495_p(this.getTilePos());
        this.getTileWorld().func_184138_a(this.getTilePos(), state, state, 3);
    }

    default public void notifyNeighborsOfStateChange() {
        this.getTileWorld().func_175685_c(this.getTilePos(), this.getTileBlockType(), true);
    }

    default public void updateComparatorOutputLevel() {
        this.getTileWorld().func_175666_e(this.getTilePos(), this.getTileBlockType());
    }

    default public void markDirtyAndNotify(boolean notifyNeighbors) {
        this.markTileDirty();
        this.notifyBlockUpdate();
        if (notifyNeighbors) {
            this.notifyNeighborsOfStateChange();
        }
    }

    @Deprecated
    default public void markDirtyAndNotify() {
        this.markDirtyAndNotify(true);
    }

    @Nonnull
    default public EnumFacing nonNullSide(@Nullable EnumFacing side) {
        return side == null ? EnumFacing.DOWN : side;
    }

    @Nonnull
    default public List<String> addToHWYLATooltip(@Nonnull List<String> tooltip) {
        return tooltip;
    }
}

