/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class InfuserRecipes
extends BasicRecipeHandler {
    public InfuserRecipes() {
        super("infuser", 1, 1, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addOxidizingRecipe("ingotThorium", 1000);
        this.addOxidizingRecipe("dustThorium", 1000);
        this.addOxidizingRecipe("ingotManganese", 1000);
        this.addOxidizingRecipe("dustManganese", 1000);
        this.addRecipe("ingotManganeseOxide", InfuserRecipes.fluidStack("oxygen", 1000), "ingotManganeseDioxide", 1.0, 1.0);
        this.addRecipe("dustManganeseOxide", InfuserRecipes.fluidStack("oxygen", 1000), "dustManganeseDioxide", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new Block[]{Blocks.field_150432_aD, Blocks.field_150403_cj}), InfuserRecipes.fluidStack("liquid_helium", 50), NCBlocks.supercold_ice, 0.2, 0.5);
        this.addRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 0), InfuserRecipes.fluidStack("liquid_nitrogen", 1000), new ItemStack(NCBlocks.fission_heater_port2, 1, 12), 1.0, 1.0);
        this.addRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 0), InfuserRecipes.fluidStack("liquid_helium", 1000), new ItemStack(NCBlocks.fission_heater_port2, 1, 13), 1.0, 1.0);
        if (!OreDictHelper.oreExists("ingotEnderium")) {
            this.addRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 0), InfuserRecipes.fluidStack("enderium", 576), new ItemStack(NCBlocks.fission_heater_port2, 1, 14), 1.0, 1.0);
        }
        if (!OreDictHelper.oreExists("dustCryotheum")) {
            this.addRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 0), InfuserRecipes.fluidStack("cryotheum", 1000), new ItemStack(NCBlocks.fission_heater_port2, 1, 15), 1.0, 1.0);
        }
        this.addRecipe("emptyHeatSink", InfuserRecipes.fluidStack("water", 1000), new ItemStack(NCBlocks.solid_fission_sink, 1, 0), 1.0, 1.0);
        this.addRecipe("emptyHeatSink", InfuserRecipes.fluidStack("liquid_nitrogen", 1000), new ItemStack(NCBlocks.solid_fission_sink2, 1, 12), 1.0, 1.0);
        this.addRecipe("emptyHeatSink", InfuserRecipes.fluidStack("liquid_helium", 1000), new ItemStack(NCBlocks.solid_fission_sink2, 1, 13), 1.0, 1.0);
        if (!OreDictHelper.oreExists("ingotEnderium")) {
            this.addRecipe("emptyHeatSink", InfuserRecipes.fluidStack("enderium", 576), new ItemStack(NCBlocks.solid_fission_sink2, 1, 14), 1.0, 1.0);
        }
        if (!OreDictHelper.oreExists("dustCryotheum")) {
            this.addRecipe("emptyHeatSink", InfuserRecipes.fluidStack("cryotheum", 1000), new ItemStack(NCBlocks.solid_fission_sink2, 1, 15), 1.0, 1.0);
        }
        this.addRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 0), InfuserRecipes.fluidStack("liquid_nitrogen", 1000), new ItemStack(NCBlocks.salt_fission_heater2, 1, 12), 1.0, 1.0);
        this.addRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 0), InfuserRecipes.fluidStack("liquid_helium", 1000), new ItemStack(NCBlocks.salt_fission_heater2, 1, 13), 1.0, 1.0);
        if (!OreDictHelper.oreExists("ingotEnderium")) {
            this.addRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 0), InfuserRecipes.fluidStack("enderium", 576), new ItemStack(NCBlocks.salt_fission_heater2, 1, 14), 1.0, 1.0);
        }
        if (!OreDictHelper.oreExists("dustCryotheum")) {
            this.addRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 0), InfuserRecipes.fluidStack("cryotheum", 1000), new ItemStack(NCBlocks.salt_fission_heater2, 1, 15), 1.0, 1.0);
        }
        this.addRecipe(InfuserRecipes.oreStack("bioplastic", 2), InfuserRecipes.fluidStack("radaway", 250), NCItems.radaway, 1.0, 0.5);
        this.addRecipe(InfuserRecipes.oreStack("bioplastic", 2), InfuserRecipes.fluidStack("radaway_slow", 250), NCItems.radaway_slow, 1.0, 0.5);
        this.addRecipe(NCItems.radaway, InfuserRecipes.fluidStack("redstone", 200), NCItems.radaway_slow, 1.0, 0.5);
        this.addRecipe("emptyFrame", InfuserRecipes.fluidStack("water", 2000), NCBlocks.water_source, 1.0, 1.0);
        this.addRecipe(NCBlocks.water_source, InfuserRecipes.fluidStack("lava", 1000), NCBlocks.cobblestone_generator, 1.0, 1.0);
        this.addRecipe("emptyFrame", InfuserRecipes.fluidStackList(Lists.newArrayList((Object[])new String[]{"heavywater", "heavy_water"}), 1000), NCBlocks.heavy_water_moderator, 1.0, 1.0);
        this.addRecipe(OreDictHelper.oreExists("blockGlassHardened") ? "blockGlassHardened" : "blockGlass", InfuserRecipes.fluidStack("tritium", 1000), NCBlocks.tritium_lamp, 1.0, 1.0);
        this.addRecipe("sandstone", InfuserRecipes.fluidStack("ender", 250), Blocks.field_150377_bs, 1.0, 1.0);
        for (int meta = 0; meta < 16; ++meta) {
            this.addRecipe(new ItemStack(Blocks.field_192444_dS, 1, meta), InfuserRecipes.fluidStack("water", 1000), new ItemStack(Blocks.field_192443_dR, 1, meta), 0.5, 0.5);
        }
        this.addRecipe("plankWood", InfuserRecipes.fluidStack("creosote", 125), RegistryHelper.blockStackFromRegistry("immersiveengineering:treated_wood"), 0.25, 0.5);
        this.addIngotInfusionRecipes("Electrum", "redstone", 200, "ElectrumFlux", 1.0, 1.0);
        this.addIngotInfusionRecipes("Shibuichi", "redstone", 250, "Signalum", 1.0, 1.0);
        this.addIngotInfusionRecipes("TinSilver", "glowstone", 250, "Lumium", 1.0, 1.0);
        this.addIngotInfusionRecipes("LeadPlatinum", "ender", 250, "Enderium", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dirt", "grass"}), InfuserRecipes.fluidStack("water", 2000), Blocks.field_150435_aG, 1.0, 1.0);
        this.addRecipe("ingotBrick", InfuserRecipes.fluidStack("water", 2000), Items.field_151119_aD, 1.0, 1.0);
        this.addRecipe(Blocks.field_150405_ch, InfuserRecipes.fluidStack("water", 4000), Blocks.field_150435_aG, 4.0, 1.0);
        this.addFissionInfusionRecipes();
    }

    public void addOxidizingRecipe(String fluidName, int oxygenAmount) {
        this.addRecipe(fluidName, InfuserRecipes.fluidStack("oxygen", oxygenAmount), fluidName + "Oxide", 1.0, 1.0);
    }

    public void addIngotInfusionRecipes(String in, String fluid, int amount, String out, double time, double power) {
        this.addRecipe("ingot" + in, InfuserRecipes.fluidStack(fluid, amount), "ingot" + out, time, power);
        this.addRecipe("dust" + in, InfuserRecipes.fluidStack(fluid, amount), "dust" + out, time, power);
    }

    public void addFissionInfusionRecipes() {
        for (String element : FissionHelper.FISSION_ORE_DICT) {
            this.addRecipe("ingot" + element, InfuserRecipes.fluidStack("oxygen", 1000), "ingot" + element + "Oxide", 1.0, 1.0);
            this.addRecipe("ingot" + element, InfuserRecipes.fluidStack("nitrogen", 1000), "ingot" + element + "Nitride", 1.0, 1.0);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

