/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;

public class CentrifugeRecipes
extends BasicRecipeHandler {
    public CentrifugeRecipes() {
        super("centrifuge", 0, 1, 0, 6);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(CentrifugeRecipes.fluidStack("boron", 192), CentrifugeRecipes.fluidStack("boron_11", 144), CentrifugeRecipes.fluidStack("boron_10", 48), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.3333333333333333, 1.0);
        this.addRecipe(CentrifugeRecipes.fluidStack("lithium", 160), CentrifugeRecipes.fluidStack("lithium_7", 144), CentrifugeRecipes.fluidStack("lithium_6", 16), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.1111111111111112, 1.0);
        this.addRecipe(CentrifugeRecipes.fluidStack("redstone_ethanol", 500), CentrifugeRecipes.fluidStack("ethanol", 500), CentrifugeRecipes.fluidStack("redstone", 400), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addCoolantNAKRecipe("iron", 144);
        this.addCoolantNAKRecipe("redstone", 200);
        this.addCoolantNAKRecipe("quartz", 1332);
        this.addCoolantNAKRecipe("obsidian", 360);
        this.addCoolantNAKRecipe("nether_brick", 360);
        this.addCoolantNAKRecipe("glowstone", 500);
        this.addCoolantNAKRecipe("lapis", 1332);
        this.addCoolantNAKRecipe("gold", 144);
        this.addCoolantNAKRecipe("prismarine", 144);
        this.addCoolantNAKRecipe("slime", 288);
        this.addCoolantNAKRecipe("end_stone", 360);
        this.addCoolantNAKRecipe("purpur", 360);
        this.addCoolantNAKRecipe("diamond", 666);
        this.addCoolantNAKRecipe("emerald", 666);
        this.addCoolantNAKRecipe("copper", 144);
        this.addCoolantNAKRecipe("tin", 144);
        this.addCoolantNAKRecipe("lead", 144);
        this.addCoolantNAKRecipe("boron", 144);
        this.addCoolantNAKRecipe("lithium", 144);
        this.addCoolantNAKRecipe("magnesium", 144);
        this.addCoolantNAKRecipe("manganese", 144);
        this.addCoolantNAKRecipe("aluminum", 144);
        this.addCoolantNAKRecipe("silver", 144);
        this.addCoolantNAKRecipe("fluorite", 1332);
        this.addCoolantNAKRecipe("villiaumite", 1332);
        this.addCoolantNAKRecipe("carobbiite", 1332);
        this.addCoolantNAKRecipe("arsenic", 1332);
        this.addCoolantNAKRecipe("liquid_nitrogen", 250);
        this.addCoolantNAKRecipe("liquid_helium", 250);
        this.addCoolantNAKRecipe("enderium", 144);
        this.addCoolantNAKRecipe("cryotheum", 250);
        this.addRecipe(CentrifugeRecipes.fluidStack("uranium", 160), CentrifugeRecipes.fluidStack("uranium_238", 144), CentrifugeRecipes.fluidStack("uranium_235", 16), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.1111111111111112, 1.0);
        this.addFissionFuelIsotopeRecipes("u", "uranium", 238, 233, 235);
        this.addFissionFuelIsotopeRecipes("n", "neptunium", 237, 236);
        this.addFissionFuelIsotopeRecipes("p", "plutonium", 242, 239, 241);
        for (int fissile : new int[]{239, 241}) {
            this.addRecipe(CentrifugeRecipes.fluidStack("mix_" + fissile, 144), CentrifugeRecipes.fluidStack("uranium_238", 128), CentrifugeRecipes.fluidStack("plutonium_" + fissile, 16), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.0, 1.0);
        }
        this.addFissionFuelIsotopeRecipes("a", "americium", 243, 242);
        this.addFissionFuelIsotopeRecipes("cm", "curium", 246, 243, 245, 247);
        this.addFissionFuelIsotopeRecipes("b", "berkelium", 247, 248);
        this.addFissionFuelIsotopeRecipes("cf", "californium", 252, 249, 251);
        this.addFissionFLIBERecipes();
        this.addReprocessingRecipe("tbu", "uranium_233", 1, "uranium_238", 5, "neptunium_236", 1, "neptunium_237", 1, "strontium_90", "caesium_137", 0.5, 50);
        this.addReprocessingRecipe("leu_233", "uranium_238", 5, "plutonium_241", 1, "plutonium_242", 1, "americium_243", 1, "strontium_90", "caesium_137", 0.5, 50);
        this.addReprocessingRecipe("heu_233", "uranium_235", 1, "uranium_238", 2, "plutonium_242", 3, "americium_243", 1, "strontium_90", "caesium_137", 1.5, 50);
        this.addReprocessingRecipe("leu_235", "uranium_238", 4, "plutonium_239", 1, "plutonium_242", 2, "americium_243", 1, "molybdenum", "caesium_137", 0.5, 50);
        this.addReprocessingRecipe("heu_235", "uranium_238", 3, "neptunium_236", 1, "plutonium_242", 2, "americium_243", 1, "molybdenum", "caesium_137", 1.5, 50);
        this.addReprocessingRecipe("len_236", "uranium_238", 4, "neptunium_237", 1, "plutonium_241", 1, "plutonium_242", 2, "molybdenum", "caesium_137", 0.5, 50);
        this.addReprocessingRecipe("hen_236", "uranium_238", 4, "plutonium_238", 1, "plutonium_241", 1, "plutonium_242", 1, "molybdenum", "caesium_137", 1.5, 50);
        this.addReprocessingRecipe("lep_239", "plutonium_242", 5, "americium_242", 1, "americium_243", 1, "curium_246", 1, "strontium_90", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("hep_239", "plutonium_241", 1, "americium_242", 1, "americium_243", 4, "curium_243", 1, "strontium_90", "promethium_147", 1.5, 50);
        this.addReprocessingRecipe("lep_241", "plutonium_242", 5, "americium_243", 1, "curium_246", 1, "berkelium_247", 1, "strontium_90", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("hep_241", "americium_241", 1, "americium_242", 1, "americium_243", 3, "curium_246", 2, "strontium_90", "promethium_147", 1.5, 50);
        this.addReprocessingRecipe("mix_239", "uranium_238", 4, "plutonium_241", 1, "plutonium_242", 2, "americium_243", 1, "strontium_90", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("mix_241", "uranium_238", 3, "plutonium_241", 1, "plutonium_242", 3, "americium_243", 1, "strontium_90", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("lea_242", "americium_243", 3, "curium_245", 1, "curium_246", 3, "berkelium_248", 1, "molybdenum", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("hea_242", "americium_243", 3, "curium_243", 1, "curium_246", 2, "berkelium_247", 1, "molybdenum", "promethium_147", 1.5, 50);
        this.addReprocessingRecipe("lecm_243", "curium_246", 4, "curium_247", 1, "berkelium_247", 2, "berkelium_248", 1, "molybdenum", "promethium_147", 0.5, 50);
        this.addReprocessingRecipe("hecm_243", "curium_245", 1, "curium_246", 3, "berkelium_247", 2, "berkelium_248", 1, "molybdenum", "promethium_147", 1.5, 50);
        this.addReprocessingRecipe("lecm_245", "curium_246", 4, "curium_247", 1, "berkelium_247", 2, "californium_249", 1, "molybdenum", "europium_155", 0.5, 60);
        this.addReprocessingRecipe("hecm_245", "curium_246", 3, "curium_247", 1, "berkelium_247", 2, "californium_249", 1, "molybdenum", "europium_155", 1.5, 60);
        this.addReprocessingRecipe("lecm_247", "curium_246", 5, "berkelium_247", 1, "berkelium_248", 1, "californium_249", 1, "molybdenum", "europium_155", 0.5, 60);
        this.addReprocessingRecipe("hecm_247", "berkelium_247", 4, "berkelium_248", 1, "californium_249", 1, "californium_251", 1, "molybdenum", "europium_155", 1.5, 60);
        this.addReprocessingRecipe("leb_248", "berkelium_247", 5, "berkelium_248", 1, "californium_249", 1, "californium_251", 1, "ruthenium_106", "promethium_147", 0.5, 60);
        this.addReprocessingRecipe("heb_248", "berkelium_248", 1, "californium_249", 1, "californium_251", 2, "californium_252", 3, "ruthenium_106", "promethium_147", 1.5, 60);
        this.addReprocessingRecipe("lecf_249", "californium_252", 2, "californium_252", 2, "californium_252", 2, "californium_252", 2, "ruthenium_106", "promethium_147", 0.5, 60);
        this.addReprocessingRecipe("hecf_249", "californium_250", 1, "californium_252", 2, "californium_252", 2, "californium_252", 2, "ruthenium_106", "promethium_147", 1.5, 60);
        this.addReprocessingRecipe("lecf_251", "californium_252", 2, "californium_252", 2, "californium_252", 2, "californium_252", 2, "ruthenium_106", "europium_155", 0.5, 60);
        this.addReprocessingRecipe("hecf_251", "californium_252", 2, "californium_252", 2, "californium_252", 2, "californium_252", 1, "ruthenium_106", "europium_155", 1.5, 60);
    }

    public void addCoolantNAKRecipe(String fluidName, int amount) {
        this.addRecipe(CentrifugeRecipes.fluidStack(fluidName + "_nak", 144), CentrifugeRecipes.fluidStack(fluidName, amount), CentrifugeRecipes.fluidStack("nak", 144), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 0.5, 1.0);
    }

    public void addFissionFuelIsotopeRecipes(String suffix, String element, int fertile, int ... fissiles) {
        for (int fissile : fissiles) {
            this.addRecipe(CentrifugeRecipes.fluidStack("le" + suffix + "_" + fissile, 144), CentrifugeRecipes.fluidStack(element + "_" + fertile, 128), CentrifugeRecipes.fluidStack(element + "_" + fissile, 16), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.0, 1.0);
            this.addRecipe(CentrifugeRecipes.fluidStack("he" + suffix + "_" + fissile, 144), CentrifugeRecipes.fluidStack(element + "_" + fertile, 96), CentrifugeRecipes.fluidStack(element + "_" + fissile, 48), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addFissionFLIBERecipes() {
        for (String element : FissionHelper.FISSION_FLUID) {
            this.addRecipe(CentrifugeRecipes.fluidStack(element + "_fluoride_flibe", 72), CentrifugeRecipes.fluidStack(element + "_fluoride", 72), CentrifugeRecipes.fluidStack("flibe", 72), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 0.5, 1.0);
            this.addRecipe(CentrifugeRecipes.fluidStack("depleted_" + element + "_fluoride_flibe", 72), CentrifugeRecipes.fluidStack("depleted_" + element + "_fluoride", 72), CentrifugeRecipes.fluidStack("flibe", 72), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), CentrifugeRecipes.emptyFluidStack(), 0.5, 1.0);
        }
    }

    public void addReprocessingRecipe(String fuel, String out1, int n1, String out2, int n2, String out3, int n3, String out4, int n4, String waste1, String waste2, double w, int r) {
        this.addRecipe(CentrifugeRecipes.fluidStack("depleted_" + fuel, 144), CentrifugeRecipes.fluidStack(out1, 16 * n1), CentrifugeRecipes.fluidStack(out2, 16 * n2), CentrifugeRecipes.chanceFluidStack(waste1, 16, (int)(w * (double)r), 16), CentrifugeRecipes.fluidStack(out3, 16 * n3), CentrifugeRecipes.fluidStack(out4, 16 * n4), CentrifugeRecipes.chanceFluidStack(waste2, 16, (int)(w * (double)(100 - r)), 16), 1.0, 1.0);
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }

    @Override
    public List<Object> getFactoredExtras(List<Object> extras, int factor) {
        ArrayList<Object> factored = new ArrayList<Object>(extras);
        factored.set(0, (Double)extras.get(0) / (double)factor);
        return factored;
    }
}

