/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientOr;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class FluidArrayIngredient
implements IFluidIngredient {
    public List<IFluidIngredient> ingredientList;
    public List<FluidStack> cachedStackList = new ArrayList<FluidStack>();

    public FluidArrayIngredient(IFluidIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public FluidArrayIngredient(List<IFluidIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add((FluidStack)input.getStack()));
    }

    @Override
    public FluidStack getStack() {
        return this.isValid() ? this.cachedStackList.get(0).copy() : null;
    }

    @Override
    public List<FluidStack> getInputStackList() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((FluidStack)obj)));
        return stacks;
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        return this.isValid() ? Lists.newArrayList((Object[])new FluidStack[]{this.getStack()}) : new ArrayList();
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredientList.get(ingredientNumber).getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IFluidIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (FluidStack stack : this.cachedStackList) {
            stack.amount = stackSize;
        }
    }

    @Override
    public String getIngredientName() {
        return this.getIngredientNamesConcat();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IFluidIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public String getIngredientRecipeString() {
        String names = "";
        for (IFluidIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    @Override
    public IntList getFactors() {
        IntArrayList list = new IntArrayList();
        for (IFluidIngredient ingredient : this.ingredientList) {
            list.addAll(ingredient.getFactors());
        }
        return new IntArrayList((IntList)list);
    }

    @Override
    public IFluidIngredient getFactoredIngredient(int factor) {
        ArrayList<IFluidIngredient> list = new ArrayList<IFluidIngredient>();
        for (IFluidIngredient ingredient : this.ingredientList) {
            list.add(ingredient.getFactoredIngredient(factor));
        }
        return new FluidArrayIngredient(list);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        if (object instanceof FluidArrayIngredient) {
            block0: for (IFluidIngredient ingredient : this.ingredientList) {
                for (IFluidIngredient ingr : ((FluidArrayIngredient)object).ingredientList) {
                    if (!ingredient.match(ingr, sorption).matches()) continue;
                    continue block0;
                }
                return IngredientMatchResult.FAIL;
            }
            return IngredientMatchResult.PASS_0;
        }
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).match(object, sorption).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty();
    }

    @Override
    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        IIngredient[] array = new IIngredient[this.ingredientList.size()];
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            array[i] = this.ingredientList.get(i).ct();
        }
        return new IngredientOr(array);
    }
}

