/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.PlacementRule;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbinePlacement;
import nc.multiblock.turbine.tile.ITurbinePart;
import nc.multiblock.turbine.tile.TileTurbinePart;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.EnergyHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")
public abstract class TileTurbineDynamoPart
extends TileTurbinePart
implements ITickable,
ITileEnergy,
IEnergySource {
    protected final EnergyStorage backupStorage = new EnergyStorage(1L);
    protected final EnergyConnection[] energyConnections = ITileEnergy.energyConnectionAll(EnergyConnection.OUT);
    protected final EnergyTileWrapper[] energySides = ITileEnergy.getDefaultEnergySides(this);
    protected final EnergyTileWrapperGT[] energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    protected boolean ic2reg = false;
    public String partName;
    public Double conductivity;
    public boolean isSearched = false;
    public boolean isInValidPosition = false;
    public String ruleID;
    public PlacementRule<Turbine, ITurbinePart> placementRule;

    public TileTurbineDynamoPart() {
        super(CuboidalPartPositionType.WALL);
    }

    public TileTurbineDynamoPart(String partName, Double conductivity, String ruleID) {
        super(CuboidalPartPositionType.WALL);
        this.partName = partName;
        this.conductivity = conductivity;
        this.ruleID = ruleID;
        this.placementRule = (PlacementRule)TurbinePlacement.RULE_MAP.get((Object)ruleID);
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void dynamoSearch(ObjectSet<TileTurbineDynamoPart> validCache, ObjectSet<TileTurbineDynamoPart> searchCache, Long2ObjectMap<TileTurbineDynamoPart> partFailCache, Long2ObjectMap<TileTurbineDynamoPart> assumedValidCache) {
        if (!this.isDynamoPartValid(partFailCache, assumedValidCache)) {
            return;
        }
        if (this.isSearched) {
            return;
        }
        this.isSearched = true;
        validCache.add((Object)this);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileTurbineDynamoPart part = (TileTurbineDynamoPart)((Turbine)this.getMultiblock()).getPartMap(TileTurbineDynamoPart.class).get(this.getTilePos().func_177972_a(dir).func_177986_g());
            if (part == null) continue;
            searchCache.add((Object)part);
        }
    }

    public boolean isDynamoPartValid(Long2ObjectMap<TileTurbineDynamoPart> partFailCache, Long2ObjectMap<TileTurbineDynamoPart> assumedValidCache) {
        if (partFailCache.containsKey(this.field_174879_c.func_177986_g())) {
            this.isInValidPosition = false;
            return false;
        }
        if (this.placementRule.requiresRecheck()) {
            this.isInValidPosition = this.placementRule.satisfied(this);
            if (this.isInValidPosition) {
                assumedValidCache.put(this.field_174879_c.func_177986_g(), (Object)this);
            }
            return this.isInValidPosition;
        }
        if (this.isInValidPosition) {
            return true;
        }
        this.isInValidPosition = this.placementRule.satisfied(this);
        return this.isInValidPosition;
    }

    public boolean isSearchRoot() {
        for (String dep : this.placementRule.getDependencies()) {
            if (!dep.equals("bearing")) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.pushEnergy();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        if (!this.isInValidPosition || !this.isMultiblockAssembled()) {
            return this.backupStorage;
        }
        return ((Turbine)this.getMultiblock()).energyStorage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    @Override
    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public int getSourceTier() {
        if (!this.isInValidPosition || !this.isMultiblockAssembled()) {
            return 1;
        }
        return EnergyHelper.getEUTier(((Turbine)this.getMultiblock()).power);
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return ITileEnergy.super.emitsEnergyTo(receiver, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return ITileEnergy.super.getOfferedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        ITileEnergy.super.drawEnergy(amount);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74778_a("partName", this.partName);
        if (this.conductivity != null) {
            nbt.func_74780_a("conductivity", this.conductivity.doubleValue());
        }
        nbt.func_74778_a("ruleID", this.ruleID);
        this.writeEnergyConnections(nbt);
        nbt.func_74757_a("isInValidPosition", this.isInValidPosition);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("partName")) {
            this.partName = nbt.func_74779_i("partName");
        }
        if (nbt.func_74764_b("conductivity")) {
            this.conductivity = nbt.func_74769_h("conductivity");
        }
        if (nbt.func_74764_b("ruleID")) {
            this.ruleID = nbt.func_74779_i("ruleID");
            this.placementRule = (PlacementRule)TurbinePlacement.RULE_MAP.get((Object)this.ruleID);
        }
        this.readEnergyConnections(nbt);
        this.isInValidPosition = nbt.func_74767_n("isInValidPosition");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.hasEnergySideCapability(side)) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergySide(this.nonNullSide(side)));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.getEnergySideGT(this.nonNullSide(side)));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

