/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.tile.internal.heat.HeatBuffer;

public class FissionCluster {
    protected final FissionReactor reactor;
    protected int id;
    protected final Long2ObjectMap<IFissionComponent> componentMap = new Long2ObjectOpenHashMap();
    public final HeatBuffer heatBuffer = new HeatBuffer(25000L);
    public boolean connectedToWall = false;
    public int componentCount = 0;
    public int fuelComponentCount = 0;
    public long cooling = 0L;
    public long rawHeating = 0L;
    public long rawHeatingIgnoreCoolingPenalty = 0L;
    public long totalHeatMult = 0L;
    public double effectiveHeating = 0.0;
    public double effectiveHeatingIgnoreCoolingPenalty = 0.0;
    public double meanHeatMult = 0.0;
    public double totalEfficiency = 0.0;
    public double totalEfficiencyIgnoreCoolingPenalty = 0.0;
    public double meanEfficiency = 0.0;
    public double overcoolingEfficiencyFactor = 0.0;
    public double undercoolingLifetimeFactor = 0.0;
    public double totalHeatingSpeedMultiplier = 0.0;
    public double meanHeatingSpeedMultiplier = 0.0;

    public FissionCluster(FissionReactor reactor, int id) {
        this.reactor = reactor;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        this.id = newId;
    }

    public Long2ObjectMap<IFissionComponent> getComponentMap() {
        return this.componentMap;
    }

    public long getNetHeating() {
        return this.rawHeating - this.cooling;
    }

    public void distributeHeatToComponents() {
        if (this.componentMap.isEmpty()) {
            return;
        }
        long distributedHeat = (long)Math.ceil((double)this.heatBuffer.getHeatStored() / (double)this.componentMap.size());
        for (IFissionComponent component : this.componentMap.values()) {
            component.setHeatStored(this.heatBuffer.removeHeat(distributedHeat, false));
            if (this.heatBuffer.getHeatStored() != 0L) continue;
            return;
        }
        this.heatBuffer.setHeatStored(0L);
    }

    public void recoverHeatFromComponents() {
        this.heatBuffer.setHeatStored(0L);
        for (IFissionComponent component : this.componentMap.values()) {
            this.heatBuffer.addHeat(component.getHeatStored(), false);
            component.setHeatStored(0L);
        }
    }

    public int getTemperature() {
        return Math.round((float)this.reactor.ambientTemp + (float)(2400 - this.reactor.ambientTemp) * (float)this.heatBuffer.getHeatStored() / (float)this.heatBuffer.getHeatCapacity());
    }

    public float getBurnDamage() {
        return this.getTemperature() < 373 ? 0.0f : 1.0f + (float)(this.getTemperature() - 373) / 200.0f;
    }
}

