/*
 * Decompiled with CFR 0.152.
 */
package nc.fluid;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class NCFluid
extends Fluid {
    public NCFluid(String fluidName, boolean canBeStill) {
        super(fluidName, NCFluid.stillTextureLocation(fluidName, canBeStill), NCFluid.flowingTextureLocation(fluidName, canBeStill));
        if (FluidRegistry.registerFluid((Fluid)this)) {
            FluidRegistry.addBucketForFluid((Fluid)this);
        }
    }

    public NCFluid(String fluidName, boolean canBeStill, String textureName, Integer color) {
        super(fluidName, NCFluid.stillTextureLocation(textureName, canBeStill), NCFluid.flowingTextureLocation(textureName, canBeStill));
        int fixedColor = color;
        if ((fixedColor >> 24 & 0xFF) == 0) {
            fixedColor |= 0xFF000000;
        }
        this.setColor(fixedColor);
        if (FluidRegistry.registerFluid((Fluid)this)) {
            FluidRegistry.addBucketForFluid((Fluid)this);
        }
    }

    public NCFluid(String fluidName, Integer colour) {
        this(fluidName, true, "liquid", colour);
    }

    private static ResourceLocation stillTextureLocation(String textureName, boolean canBeStill) {
        return new ResourceLocation("nuclearcraft:blocks/fluids/" + textureName + (canBeStill ? "_still" : ""));
    }

    private static ResourceLocation flowingTextureLocation(String textureName, boolean canBeStill) {
        return new ResourceLocation("nuclearcraft:blocks/fluids/" + textureName + (canBeStill ? "_flow" : ""));
    }
}

