/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.radiation;

import nc.block.tile.BlockSimpleTile;
import nc.config.NCConfig;
import nc.enumm.BlockEnums;
import nc.radiation.RadiationHelper;
import nc.tile.radiation.TileRadiationScrubber;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class BlockScrubber
extends BlockSimpleTile {
    public BlockScrubber() {
        super(BlockEnums.SimpleTileType.RADIATION_SCRUBBER);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (player != null && player.func_184586_b(hand).func_190926_b()) {
            TileEntity tile = world.func_175625_s(pos);
            if (!world.field_72995_K && tile instanceof TileRadiationScrubber) {
                TileRadiationScrubber scrubber = (TileRadiationScrubber)tile;
                scrubber.checkRadiationEnvironmentInfo();
                double radRemoval = scrubber.getRawScrubberRate();
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("message.nuclearcraft.scrubber_removal_rate") + " " + (Math.abs(radRemoval) < NCConfig.radiation_lowest_rate ? "0 Rad/t" : RadiationHelper.radsPrefix(radRemoval, true)) + " [" + NCMath.pcDecimalPlaces(Math.abs(scrubber.getRadiationContributionFraction() / TileRadiationScrubber.getMaxScrubberFraction()), 1) + "]"));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }
}

