/*
 * Decompiled with CFR 0.152.
 */
package nc.block.plant;

import java.util.Random;
import nc.config.NCConfig;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public abstract class NCBlockMushroom
extends BlockMushroom {
    public NCBlockMushroom() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (NCConfig.mushroom_spread_rate <= 0) {
            return;
        }
        if (rand.nextInt(Math.max(1, NCMath.toInt(400.0 / (double)NCConfig.mushroom_spread_rate))) == 0) {
            int count = 0;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (world.func_180495_p(blockpos).func_177230_c() != this || ++count <= 4) continue;
                return;
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos spreadPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4));
                if (!world.func_175623_d(spreadPos) || !this.func_180671_f(world, spreadPos, this.func_176223_P())) continue;
                world.func_180501_a(spreadPos, this.func_176223_P(), 2);
                return;
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Cave;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() > 0 && pos.func_177956_o() < worldIn.func_72800_K()) {
            return this.canGroundSustainPlant(worldIn, pos.func_177977_b());
        }
        return false;
    }

    protected boolean canGroundSustainPlant(World worldIn, BlockPos groundPos) {
        IBlockState ground = worldIn.func_180495_p(groundPos);
        return ground.func_177230_c().canSustainPlant(worldIn.func_180495_p(groundPos), (IBlockAccess)worldIn, groundPos, EnumFacing.UP, (IPlantable)this);
    }

    public abstract boolean func_176473_a(World var1, BlockPos var2, IBlockState var3, boolean var4);

    protected abstract HugeMushroomGenerator getHugeMushroomGenerator(World var1, Random var2, BlockPos var3);

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (this.func_176473_a(worldIn, pos, state, false)) {
            worldIn.func_175698_g(pos);
            if (!this.getHugeMushroomGenerator(worldIn, rand, pos).func_180709_b(worldIn, rand, pos)) {
                worldIn.func_180501_a(pos, state, 3);
            }
        }
    }

    protected class HugeMushroomGenerator
    extends WorldGenerator {
        protected final Block hugeBlock;
        protected final boolean flatCap;

        public HugeMushroomGenerator(Block hugeBlock, boolean flatCap) {
            super(true);
            this.hugeBlock = hugeBlock;
            this.flatCap = flatCap;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int i = rand.nextInt(3) + 4;
            if (rand.nextInt(12) == 0) {
                i *= 2;
            }
            boolean flag = true;
            if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 < worldIn.func_72800_K()) {
                for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + i; ++j) {
                    int k = 3;
                    if (j <= pos.func_177956_o() + 3) {
                        k = 0;
                    }
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                        for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                            if (j >= 0 && j < worldIn.func_72800_K()) {
                                IBlockState state = worldIn.func_180495_p((BlockPos)mutablePos.func_181079_c(l, j, i1));
                                if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, (BlockPos)mutablePos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, (BlockPos)mutablePos)) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                if (!flag) {
                    return false;
                }
                if (!NCBlockMushroom.this.canGroundSustainPlant(worldIn, pos.func_177977_b())) {
                    return false;
                }
                int k2 = pos.func_177956_o() + i;
                if (!this.flatCap) {
                    k2 = pos.func_177956_o() + i - 3;
                }
                for (int l2 = k2; l2 <= pos.func_177956_o() + i; ++l2) {
                    int j3 = 1;
                    if (l2 < pos.func_177956_o() + i) {
                        ++j3;
                    }
                    if (this.flatCap) {
                        j3 = 3;
                    }
                    int k3 = pos.func_177958_n() - j3;
                    int l3 = pos.func_177958_n() + j3;
                    int j1 = pos.func_177952_p() - j3;
                    int k1 = pos.func_177952_p() + j3;
                    for (int l1 = k3; l1 <= l3; ++l1) {
                        for (int i2 = j1; i2 <= k1; ++i2) {
                            BlockPos blockpos;
                            IBlockState state;
                            int j2 = 5;
                            if (l1 == k3) {
                                --j2;
                            } else if (l1 == l3) {
                                ++j2;
                            }
                            if (i2 == j1) {
                                j2 -= 3;
                            } else if (i2 == k1) {
                                j2 += 3;
                            }
                            BlockHugeMushroom.EnumType type = BlockHugeMushroom.EnumType.func_176895_a((int)j2);
                            if (this.flatCap || l2 < pos.func_177956_o() + i) {
                                if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                                if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == j1) {
                                    type = BlockHugeMushroom.EnumType.NORTH_WEST;
                                }
                                if (l1 == k3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                    type = BlockHugeMushroom.EnumType.NORTH_WEST;
                                }
                                if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == j1) {
                                    type = BlockHugeMushroom.EnumType.NORTH_EAST;
                                }
                                if (l1 == l3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                    type = BlockHugeMushroom.EnumType.NORTH_EAST;
                                }
                                if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == k1) {
                                    type = BlockHugeMushroom.EnumType.SOUTH_WEST;
                                }
                                if (l1 == k3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                    type = BlockHugeMushroom.EnumType.SOUTH_WEST;
                                }
                                if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == k1) {
                                    type = BlockHugeMushroom.EnumType.SOUTH_EAST;
                                }
                                if (l1 == l3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                    type = BlockHugeMushroom.EnumType.SOUTH_EAST;
                                }
                            }
                            if (type == BlockHugeMushroom.EnumType.CENTER && l2 < pos.func_177956_o() + i) {
                                type = BlockHugeMushroom.EnumType.ALL_INSIDE;
                            }
                            if (pos.func_177956_o() < pos.func_177956_o() + i - 1 && type == BlockHugeMushroom.EnumType.ALL_INSIDE || !(state = worldIn.func_180495_p(blockpos = new BlockPos(l1, l2, i2))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, this.hugeBlock.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)type));
                        }
                    }
                }
                for (int j = 0; j < i; ++j) {
                    IBlockState iblockstate = worldIn.func_180495_p(pos.func_177981_b(j));
                    if (!iblockstate.func_177230_c().canBeReplacedByLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177981_b(j))) continue;
                    this.func_175903_a(worldIn, pos.func_177981_b(j), this.hugeBlock.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM));
                }
                return true;
            }
            return false;
        }
    }
}

