/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.api.BCBlocks;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideAssemblyFactory;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.ChangingObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public enum GuideAssemblyRecipes implements IStackRecipes
{
    INSTANCE;


    @Override
    public List<GuidePartFactory> getUsages(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> usages = new ArrayList<GuidePartFactory>();
        boolean all = stack.func_77973_b() == Item.func_150898_a((Block)BCBlocks.Silicon.ASSEMBLY_TABLE);
        for (AssemblyRecipe recipe : AssemblyRecipeRegistry.REGISTRY.values()) {
            for (ItemStack output : recipe.getOutputPreviews()) {
                if (!all && !recipe.getInputsFor(output).stream().anyMatch(definition -> definition.ingredient.apply(stack))) continue;
                usages.add(GuideAssemblyRecipes.getFactory(recipe, output));
            }
        }
        return usages;
    }

    @Override
    public List<GuidePartFactory> getRecipes(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> recipes = new ArrayList<GuidePartFactory>();
        for (AssemblyRecipe recipe : AssemblyRecipeRegistry.REGISTRY.values()) {
            for (ItemStack output : recipe.getOutputPreviews()) {
                if (!StackUtil.isCraftingEquivalent(output, stack, false)) continue;
                recipes.add(GuideAssemblyRecipes.getFactory(recipe, output));
            }
        }
        return recipes;
    }

    private static GuideAssemblyFactory getFactory(AssemblyRecipe recipe, ItemStack output) {
        ChangingItemStack[] stacks = (ChangingItemStack[])recipe.getInputsFor(output).stream().map(definition -> {
            NonNullList items = Arrays.stream(definition.ingredient.func_193365_a()).map(ItemStack::func_77946_l).collect(StackUtil.nonNullListCollector());
            items.forEach(stack -> stack.func_190920_e(definition.count));
            return items;
        }).map(ChangingItemStack::new).toArray(ChangingItemStack[]::new);
        return new GuideAssemblyFactory(stacks, new ChangingItemStack(output), new ChangingObject<Long>(new Long[]{recipe.getRequiredMicroJoulesFor(output)}));
    }
}

