/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items.urantypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.Registry;

public class Uranium235
extends UranBaseType {
    public Uranium235() {
        this.loadDefaults();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(IUranium.RodType type) {
        return Ic2Icons.getTextures((String)"ic2c_extras_nuclear_cells")[this.getTextureID(type)];
    }

    public int getRow() {
        return 1;
    }

    public int getMaxDurability() {
        return 5000;
    }

    public float getEUPerPulse() {
        return 1.0f;
    }

    public int getPulsesPerTick() {
        return 4;
    }

    public int getPulsesForConnection() {
        return 1;
    }

    public float getHeatModifier() {
        return 0.25f;
    }

    public float getExplosionEffectModifier() {
        return 4.0f;
    }

    public ItemStack getUraniumIngot() {
        return new ItemStack((Item)Registry.uranium235Ingot);
    }

    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return new ItemStack((Item)Registry.singleUranium235Cell).func_77946_l();
            }
            case DualRod: {
                return new ItemStack((Item)Registry.doubleUranium235Cell).func_77946_l();
            }
            case QuadRod: {
                return new ItemStack((Item)Registry.quadUranium235Cell).func_77946_l();
            }
            case NearDepletedRod: {
                return new ItemStack((Item)Registry.nearDepletedUranium235Cell).func_77946_l();
            }
            case IsotopicRod: {
                return new ItemStack((Item)Registry.isotopicUranium235Cell).func_77946_l();
            }
            case ReEnrichedRod: {
                return new ItemStack((Item)Registry.reEnrichedUranium235Cell).func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage((ItemStack)this.getRodType(IUranium.RodType.IsotopicRod), (int)(this.getMaxDurability() - 1));
    }

    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 1130;
            }
            case DualRod: {
                return 1131;
            }
            case QuadRod: {
                return 1132;
            }
            case ReEnrichedRod: {
                return 1133;
            }
            case NearDepletedRod: {
                return 1134;
            }
            case IsotopicRod: {
                return 1135;
            }
        }
        return 0;
    }

    public short getTextureID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 17;
            }
            case DualRod: {
                return 11;
            }
            case QuadRod: {
                return 5;
            }
            case ReEnrichedRod: {
                return 35;
            }
            case NearDepletedRod: {
                return 23;
            }
            case IsotopicRod: {
                return 29;
            }
        }
        return 0;
    }

    public LocaleComp getName(IUranium.RodType rodType) {
        return Ic2Lang.nullKey;
    }

    public boolean isReEnrichedUran() {
        return false;
    }

    public Color getReEnrichedColor() {
        return null;
    }

    public ItemStack getIngridient() {
        return null;
    }

    public int getIngrientPoints() {
        return 0;
    }

    public int getIngridientCost() {
        return 0;
    }
}

