/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.tileentity.TileEntityAutocraftingTable;
import trinsdar.ic2c_extras.tileentity.TileEntityCutter;
import trinsdar.ic2c_extras.tileentity.TileEntityElectricDisenchanter;
import trinsdar.ic2c_extras.tileentity.TileEntityElectricHeatGenerator;
import trinsdar.ic2c_extras.tileentity.TileEntityExtruder;
import trinsdar.ic2c_extras.tileentity.TileEntityFermenter;
import trinsdar.ic2c_extras.tileentity.TileEntityFluidCanningMachine;
import trinsdar.ic2c_extras.tileentity.TileEntityImpellerizedRoller;
import trinsdar.ic2c_extras.tileentity.TileEntityLiquescentExtruder;
import trinsdar.ic2c_extras.tileentity.TileEntityMetalBender;
import trinsdar.ic2c_extras.tileentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.tileentity.TileEntityPlasmaCutter;
import trinsdar.ic2c_extras.tileentity.TileEntityReinforcedStoneCable;
import trinsdar.ic2c_extras.tileentity.TileEntityRoller;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalWasher;
import trinsdar.ic2c_extras.tileentity.TileEntityTreeTapper;
import trinsdar.ic2c_extras.util.Icons;
import trinsdar.ic2c_extras.util.Registry;

public class BlockMachine
extends BlockMultiID {
    public BlockMachine(String name, LocaleComp comp) {
        super(Material.field_151573_f);
        this.func_149711_c(4.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(IC2CExtras.creativeTab);
        this.setRegistryName("ic2c_extras", name.toLowerCase());
        this.setUnlocalizedName(comp);
        if (name.equals("reinforcedencasedcable")) {
            this.func_149711_c(80.0f);
            this.func_149752_b(150.0f);
            this.setHarvestLevel("pickaxe", 2);
        }
    }

    public List<Integer> getValidMetas() {
        return Collections.singletonList(0);
    }

    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        if (this == Registry.oreWashingPlant) {
            return new TileEntityOreWashingPlant();
        }
        if (this == Registry.thermalCentrifuge) {
            return new TileEntityThermalCentrifuge();
        }
        if (this == Registry.thermalWasher) {
            return new TileEntityThermalWasher();
        }
        if (this == Registry.roller) {
            return new TileEntityRoller();
        }
        if (this == Registry.extruder) {
            return new TileEntityExtruder();
        }
        if (this == Registry.cutter) {
            return new TileEntityCutter();
        }
        if (this == Registry.impellerizedRoller) {
            return new TileEntityImpellerizedRoller();
        }
        if (this == Registry.liquescentExtruder) {
            return new TileEntityLiquescentExtruder();
        }
        if (this == Registry.plasmaCutter) {
            return new TileEntityPlasmaCutter();
        }
        if (this == Registry.metalBender) {
            return new TileEntityMetalBender();
        }
        if (this == Registry.fluidCanningMachine) {
            return new TileEntityFluidCanningMachine();
        }
        if (this == Registry.treeTapper) {
            return new TileEntityTreeTapper();
        }
        if (this == Registry.electricDisenchanter) {
            return new TileEntityElectricDisenchanter();
        }
        if (this == Registry.autocraftingTable) {
            return new TileEntityAutocraftingTable();
        }
        if (this == Registry.reinforcedEncasedCable) {
            return new TileEntityReinforcedStoneCable();
        }
        if (this == Registry.electricHeatGenerator) {
            return new TileEntityElectricHeatGenerator();
        }
        if (this == Registry.fermenter) {
            return new TileEntityFermenter();
        }
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this == Registry.thermalCentrifuge || this == Registry.thermalWasher || this == Registry.impellerizedRoller || this == Registry.liquescentExtruder || this == Registry.plasmaCutter || this == Registry.metalBender) {
            drops.add(Ic2Items.advMachine);
        } else if (this == Registry.fluidCanningMachine) {
            drops.add(Ic2Items.canner);
        } else if (this == Registry.electricDisenchanter) {
            drops.add(Ic2Items.electricEnchanter);
        } else if (this == Registry.reinforcedEncasedCable) {
            drops.add(new ItemStack((Block)this));
        } else if (this == Registry.electricHeatGenerator) {
            drops.add(IC2.config.getFlag("SteelRecipes") ? new ItemStack((Item)Registry.steelIngot, 3) : StackUtil.copyWithSize((ItemStack)Ic2Items.refinedIronIngot, (int)3));
        } else {
            drops.add(Ic2Items.machine);
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Icons.getTextureData((Block)this);
    }

    public int getMaxSheetSize(int meta) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{allFacings, active});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState getDefaultBlockState() {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false));
        if (this.hasFacing()) {
            state = state.func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH);
        }
        return state;
    }

    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            states.add(def.func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
            states.add(def.func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        }
        return states;
    }

    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }
}

