/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.lighthouse;

import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockCrate;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.TileEntityCrate;
import com.teammetallurgy.atum.entity.efreet.EntitySunspeaker;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.world.gen.structure.lighthouse.MapGenLighthouse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class LighthousePieces {
    public static final ResourceLocation LIGHTHOUSE = new ResourceLocation("atum", "lighthouse");

    public static void registerLighthouse() {
        MapGenStructureIO.func_143034_b(MapGenLighthouse.Start.class, (String)String.valueOf(LIGHTHOUSE));
        MapGenStructureIO.func_143031_a(LighthouseTemplate.class, (String)String.valueOf(new ResourceLocation("atum", "lighthouse_template")));
    }

    public static class LighthouseTemplate
    extends StructureComponentTemplate {
        private Rotation rotation;
        private Mirror mirror;
        private int sunspeakerSpawned;

        public LighthouseTemplate() {
        }

        LighthouseTemplate(TemplateManager manager, BlockPos pos, Rotation rotation) {
            this(manager, pos, rotation, Mirror.NONE);
        }

        private LighthouseTemplate(TemplateManager manager, BlockPos pos, Rotation rotation, Mirror mirror) {
            super(0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.mirror = mirror;
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_186237_a(null, LIGHTHOUSE);
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox box) {
            super.func_74875_a(world, random, box);
            return true;
        }

        private void spawnSunspeakers(World world, StructureBoundingBox box, int x, int y, int z, int min, int max) {
            if (this.sunspeakerSpawned > 0) {
                return;
            }
            world.func_175698_g(new BlockPos(x, y, z));
            Random rand = new Random(world.func_72905_C() ^ (long)x ^ (long)(z << 16));
            int numToSpawn = rand.nextInt(1 + max - min) + min;
            int[] levels = new int[]{0, 5, 10, 22};
            ArrayList<Integer> ylevels = new ArrayList<Integer>();
            for (int i = 0; i < numToSpawn; ++i) {
                ylevels.add(y + levels[rand.nextInt(levels.length)] + 1);
            }
            HashSet<BlockPos> usedPosition = new HashSet<BlockPos>();
            int tries = 0;
            while (this.sunspeakerSpawned < numToSpawn) {
                int l;
                int k;
                int sw = 2;
                int j = x + rand.nextInt(2 * sw + 1) - sw;
                BlockPos pos = new BlockPos(j, k = ((Integer)ylevels.get(this.sunspeakerSpawned)).intValue(), l = z + rand.nextInt(2 * sw + 1) - sw);
                if (usedPosition.contains(pos)) continue;
                usedPosition.add(pos);
                if (box.func_175898_b((Vec3i)pos) && world.func_175623_d(pos)) {
                    ++this.sunspeakerSpawned;
                    EntitySunspeaker sunspeaker = new EntitySunspeaker(world);
                    sunspeaker.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    sunspeaker.func_180482_a(world.func_175649_E(new BlockPos((Entity)sunspeaker)), null);
                    world.func_72838_d((Entity)sunspeaker);
                }
                if (++tries <= 100) continue;
                break;
            }
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            if (function.equals("PalmCrate")) {
                if (box.func_175898_b((Vec3i)pos)) {
                    if (rand.nextDouble() <= 0.15) {
                        BlockCrate palmCrate = BlockCrate.getCrate(BlockAtumPlank.WoodType.PALM);
                        world.func_180501_a(pos, palmCrate.correctFacing(world, pos, palmCrate.func_176223_P()), 2);
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof TileEntityCrate) {
                            ((TileEntityCrate)tileEntity).func_189404_a(AtumLootTables.LIGHTHOUSE, rand.nextLong());
                        }
                    } else {
                        world.func_175698_g(pos);
                    }
                }
            } else if (function.equals("HeartOfRa")) {
                if (box.func_175898_b((Vec3i)pos)) {
                    world.func_180501_a(pos, AtumBlocks.HEART_OF_RA.func_176223_P(), 2);
                }
            } else if (function.equals("Sunspeaker")) {
                this.spawnSunspeakers(world, box, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2, 6);
            }
        }

        protected void func_143012_a(NBTTagCompound compound) {
            super.func_143012_a(compound);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            compound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
            compound.func_74768_a("SunspeakerCount", this.sunspeakerSpawned);
        }

        protected void func_143011_b(NBTTagCompound compound, TemplateManager manager) {
            super.func_143011_b(compound, manager);
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)compound.func_74779_i("Mi"));
            this.sunspeakerSpawned = compound.func_74762_e("SunspeakerCount");
            this.loadTemplate(manager);
        }
    }
}

