/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import com.teammetallurgy.atum.entity.animal.EntityTarantula;
import com.teammetallurgy.atum.entity.bandit.EntityBanditBase;
import com.teammetallurgy.atum.entity.efreet.EntityEfreetBase;
import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import com.teammetallurgy.atum.integration.champion.ChampionsHelper;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUndeadBase
extends EntityMob {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityUndeadBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private String texturePath;

    public EntityUndeadBase(World world) {
        super(world);
        new PathNavigateGround((EntityLiving)this, world).func_179691_c(true);
    }

    boolean hasSkinVariants() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    void func_175456_n() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityUndeadBase.class}));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBanditBase.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityStoneBase.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEfreetBase.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDesertWolf.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDesertWolf.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWolf.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPigZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTarantula.class, true));
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return !EntityUndeadBase.class.isAssignableFrom(cls) && super.func_70686_a(cls);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.hasSkinVariants()) {
            int variant = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)0, (int)this.getVariantAmount());
            this.setVariant(variant);
            this.setVariantAbilities(difficulty, variant);
        }
        return livingdata;
    }

    int getVariantAmount() {
        return 6;
    }

    void setVariantAbilities(DifficultyInstance difficulty, int variant) {
    }

    public boolean func_70687_e(@Nonnull PotionEffect potionEffect) {
        return potionEffect.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potionEffect);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_72935_r() && this.field_70170_p.func_175678_i(this.func_180425_c()) && !this.field_70170_p.field_72995_K && !this.field_70178_ae && this.shouldBurnInDay()) {
            this.func_70015_d(8);
        }
    }

    public void func_70030_z() {
        if (this.field_190534_ay > 0 && !this.field_70178_ae) {
            if (this.field_190534_ay % 20 == 0) {
                this.func_70097_a(DamageSource.field_76370_b, this.getBurnDamage());
            }
            --this.field_190534_ay;
        }
        super.func_70030_z();
    }

    float getBurnDamage() {
        return 1.0f;
    }

    boolean shouldBurnInDay() {
        return true;
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        if (i <= 62) {
            return false;
        }
        return this.canSpawnNoHeightCheck(false);
    }

    public boolean canSpawnNoHeightCheck(boolean isFromSpawner) {
        return super.func_70601_bi() && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && (isFromSpawner || !this.field_70170_p.func_72953_d(this.func_174813_aQ()));
    }

    void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            ResourceLocation texture;
            String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(((Object)((Object)this)).getClass())).getRegistryName()).func_110623_a();
            if (ChampionsHelper.isChampion((Entity)this) && (texture = ChampionsHelper.getTexture((Entity)this, entityName)) != null) {
                this.texturePath = texture.toString();
                return this.texturePath;
            }
            this.texturePath = this.hasSkinVariants() ? new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png" : new ResourceLocation("atum", "textures/entity/" + entityName) + ".png";
        }
        return this.texturePath;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
    }
}

