/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.BlockAtumDoor;
import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.blocks.machines.BlockKiln;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumRegistry;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockLimestoneBricks
extends Block
implements IRenderMapper {
    public static final PropertyBool UNBREAKABLE = PropertyBool.func_177716_a((String)"unbreakable");
    private static final Map<BrickType, BlockLimestoneBricks> BRICKS = Maps.newEnumMap(BrickType.class);
    private static final Map<BrickType, BlockAtumDoor> DOORS = Maps.newEnumMap(BrickType.class);

    private BlockLimestoneBricks() {
        super(Material.field_151576_e, MapColor.field_151658_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UNBREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (state.func_177230_c() == BlockLimestoneBricks.getBrick(BrickType.SMALL)) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos checkPos = pos.func_177982_a(dx, dy, dz);
                        IBlockState kilnState = world.func_180495_p(checkPos);
                        if (kilnState.func_177230_c() != AtumBlocks.KILN) continue;
                        BlockKiln kiln = (BlockKiln)kilnState.func_177230_c();
                        kiln.tryMakeMultiblock(world, checkPos, kilnState);
                    }
                }
            }
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)UNBREAKABLE) != false ? -1.0f : super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)UNBREAKABLE) != false ? 6000000.0f : super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public static void registerBricks() {
        for (BrickType type : BrickType.values()) {
            BlockLimestoneBricks brick = new BlockLimestoneBricks();
            BRICKS.put(type, brick);
            AtumRegistry.registerBlock(brick, "limestone_brick_" + type.func_176610_l());
        }
    }

    public static BlockLimestoneBricks getBrick(BrickType type) {
        return BRICKS.get((Object)type);
    }

    public static void registerDoors() {
        for (BrickType type : BrickType.values()) {
            BlockAtumDoor door = new BlockAtumDoor(Material.field_151576_e);
            DOORS.put(type, door);
            AtumRegistry.registerBlock((Block)door, (Item)new ItemDoor((Block)door), "limestone_brick_" + type.func_176610_l() + "_door");
        }
    }

    public static BlockAtumDoor getDoor(BrickType type) {
        return DOORS.get((Object)type);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)UNBREAKABLE, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)UNBREAKABLE) != false ? 1 : 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UNBREAKABLE});
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{UNBREAKABLE};
    }

    public static enum BrickType implements IStringSerializable
    {
        SMALL("small"),
        LARGE("large"),
        CRACKED("cracked_brick"),
        CHISELED("chiseled"),
        CARVED("carved");

        private final String name;

        private BrickType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

