/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.base.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityChestBase
extends TileEntityChest {
    public boolean canBeSingle;
    public boolean canBeDouble;
    private Block chestBlock;

    public TileEntityChestBase(boolean canBeSingle, boolean canBeDouble, Block chestBlock) {
        this.canBeSingle = canBeSingle;
        this.canBeDouble = canBeDouble;
        this.chestBlock = chestBlock;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void setNeighbor(TileEntityChest chest, EnumFacing side) {
        if (chest.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chest) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    @Nullable
    protected TileEntityChest func_174911_a(@Nonnull EnumFacing side) {
        TileEntity tileEntity;
        BlockPos pos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(pos) && this.canBeDouble && (tileEntity = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityChestBase) {
            TileEntityChestBase chestBase = (TileEntityChestBase)tileEntity;
            chestBase.setNeighbor(this, side.func_176734_d());
            return chestBase;
        }
        return null;
    }

    private boolean isChestAt(BlockPos pos) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        return block instanceof BlockChest && ((BlockChest)block).field_149956_a == this.func_145980_j() && tileEntity instanceof TileEntityChestBase && block == this.chestBlock;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public void func_184281_d(@Nullable EntityPlayer player) {
        LootTableManager manager;
        if (this.field_184284_m != null && (manager = this.field_145850_b.func_184146_ak()) != null) {
            super.func_184281_d(player);
        }
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.canBeDouble) {
            return (T)this.getSingleChestHandler();
        }
        return (T)super.getCapability(capability, facing);
    }
}

