/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.Piston;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class BlockPlaceListener
extends AbstractListener {
    private final ProtectionConfig protectionConfig;

    public BlockPlaceListener(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Listener(order=Order.EARLY)
    public void onBlockPlace(ChangeBlockEvent.Place event) {
        block11: {
            User user;
            Object source;
            block12: {
                source = event.getSource();
                if (source instanceof Piston) {
                    return;
                }
                user = null;
                if (event.getCause().containsType(Player.class)) {
                    user = (User)event.getCause().first(Player.class).get();
                } else if (event.getCause().containsType(User.class)) {
                    user = (User)event.getCause().first(User.class).get();
                }
                if (!(user instanceof Player)) break block12;
                Player player = (Player)user;
                if (source instanceof FallingBlock && this.protectionConfig.shouldAllowExplosionsByOtherPlayersInClaims()) {
                    return;
                }
                for (Transaction transaction : event.getTransactions()) {
                    if (super.getPlugin().getProtectionManager().canPlace((Location<World>)((Location)((BlockSnapshot)transaction.getFinal()).getLocation().get()), (User)player, true).hasAccess()) continue;
                    event.setCancelled(true);
                    break block11;
                }
                break block11;
            }
            if (user != null) break block11;
            Optional optionalNeighborNotifySource = event.getContext().get(EventContextKeys.NEIGHBOR_NOTIFY_SOURCE);
            if (optionalNeighborNotifySource.isPresent()) {
                BlockSnapshot blockSnapshot = (BlockSnapshot)optionalNeighborNotifySource.get();
                if (!(source instanceof BlockSnapshot)) {
                    return;
                }
                Optional sourceNotifyLocation = blockSnapshot.getLocation();
                Optional sourceLocation = ((BlockSnapshot)source).getLocation();
                if (!sourceNotifyLocation.isPresent() || !sourceLocation.isPresent()) {
                    return;
                }
                if (!super.getPlugin().getProtectionManager().canNotifyBlock((Location<World>)((Location)sourceNotifyLocation.get()), (Location<World>)((Location)sourceLocation.get())).hasAccess()) {
                    event.setCancelled(true);
                    return;
                }
            }
            for (Transaction transaction : event.getTransactions()) {
                if (((BlockSnapshot)transaction.getFinal()).getState().getType() != BlockTypes.FIRE || !super.getPlugin().getFactionLogic().getFactionByChunk(((BlockSnapshot)transaction.getFinal()).getWorldUniqueId(), ((Location)((BlockSnapshot)transaction.getFinal()).getLocation().get()).getChunkPosition()).isPresent()) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

