/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.general;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.util.ParticlesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class CoordsCommand
extends AbstractCommand {
    public CoordsCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFaction = context.getOne((Text)Text.of((String)"faction"));
        if (!(source instanceof Player)) {
            if (!optionalFaction.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You must specify faction name!"}));
            }
            return this.showCoordsList(source, this.getTeamCoordsList(null, (Faction)optionalFaction.get()));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalFaction.isPresent()) {
            Faction faction = (Faction)optionalFaction.get();
            if (super.getPlugin().getPlayerManager().hasAdminMode((User)player) || optionalPlayerFaction.isPresent() && optionalPlayerFaction.get().getName().equals(faction.getName())) {
                return this.showCoordsList((CommandSource)player, this.getTeamCoordsList(player, faction));
            }
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS}));
        }
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        return this.showCoordsList((CommandSource)player, this.getTeamCoordsList(player, playerFaction));
    }

    private List<Text> getTeamCoordsList(Player player, Faction faction) {
        Text textBuilder;
        Optional<Player> leader;
        Text textBuilder2;
        Claim claim;
        ArrayList<Text> teamCoords = new ArrayList<Text>();
        if (player != null && (claim = this.getNearestClaim(player, faction)) != null) {
            Vector3d blockPosition = ParticlesUtil.getChunkCenter(player.getWorld(), claim.getChunkPosition());
            Text textBuilder3 = Text.builder().append(new Text[]{Text.of((String)(Messages.FACTION + ": " + blockPosition))}).build();
            teamCoords.add(textBuilder3);
        }
        if (faction.getHome() != null) {
            Optional optionalHomeWorld = Sponge.getServer().getWorld(faction.getHome().getWorldUUID());
            textBuilder2 = Text.builder().append(new Text[]{Text.of((String)(Messages.FACTIONS_HOME + ": " + optionalHomeWorld.map(World::getName).orElse("Unknown World") + '|' + faction.getHome().getBlockPosition().toString()))}).build();
            teamCoords.add(textBuilder2);
        }
        if ((leader = this.getPlugin().getPlayerManager().getPlayer(faction.getLeader())).isPresent()) {
            textBuilder2 = Text.builder().append(new Text[]{Text.of((String)(Messages.LEADER + ": " + leader.get().getName() + " " + leader.get().getLocation().getBlockPosition().toString()))}).build();
            teamCoords.add(textBuilder2);
        }
        for (UUID officerUUID : faction.getOfficers()) {
            Optional<Player> officer = this.getPlugin().getPlayerManager().getPlayer(officerUUID);
            if (!officer.isPresent()) continue;
            textBuilder = Text.builder().append(new Text[]{Text.of((String)(Messages.OFFICER + ": " + officer.get().getName() + " " + officer.get().getLocation().getBlockPosition().toString()))}).build();
            teamCoords.add(textBuilder);
        }
        for (UUID memberUUID : faction.getMembers()) {
            Optional<Player> member = this.getPlugin().getPlayerManager().getPlayer(memberUUID);
            if (!member.isPresent()) continue;
            textBuilder = Text.builder().append(new Text[]{Text.of((String)(Messages.MEMBER + ": " + member.get().getName() + " " + member.get().getLocation().getBlockPosition().toString()))}).build();
            teamCoords.add(textBuilder);
        }
        for (UUID recruitUUID : faction.getRecruits()) {
            Optional<Player> recruit = this.getPlugin().getPlayerManager().getPlayer(recruitUUID);
            if (!recruit.isPresent()) continue;
            textBuilder = Text.builder().append(new Text[]{Text.of((String)(Messages.RECRUIT + ": " + recruit.get().getName() + " " + recruit.get().getLocation().getBlockPosition().toString()))}).build();
            teamCoords.add(textBuilder);
        }
        return teamCoords;
    }

    private Claim getNearestClaim(Player player, Faction faction) {
        UUID worldUUID = player.getWorld().getUniqueId();
        Vector3i chunkPosition = player.getLocation().getChunkPosition();
        Set<Claim> claims = faction.getClaims();
        if (claims.isEmpty()) {
            return null;
        }
        Claim nearestClaim = claims.iterator().next();
        for (Claim claim : claims) {
            if (!claim.getWorldUUID().equals(worldUUID)) continue;
            float distanceToCurrentClaim = nearestClaim.getChunkPosition().distance(chunkPosition);
            float distanceToNextClaim = claim.getChunkPosition().distance(chunkPosition);
            if (!(distanceToNextClaim < distanceToCurrentClaim)) continue;
            nearestClaim = claim;
        }
        if (!nearestClaim.getWorldUUID().equals(worldUUID)) {
            nearestClaim = null;
        }
        return nearestClaim;
    }

    private CommandResult showCoordsList(CommandSource commandSource, List<Text> teamCoords) throws CommandException {
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, Messages.TEAM_COORDS})).contents(teamCoords);
        paginationBuilder.sendTo((MessageReceiver)commandSource);
        return CommandResult.success();
    }
}

