/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.claiming;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class ClaimsListCommand
extends AbstractCommand {
    public ClaimsListCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFaction = context.getOne((Text)Text.of((String)"faction"));
        if (optionalFaction.isPresent()) {
            Faction faction = (Faction)optionalFaction.get();
            if (source instanceof ConsoleSource) {
                this.showClaimsList(source, faction);
                return CommandResult.success();
            }
            if (source instanceof Player) {
                Player player = (Player)source;
                if (super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
                    this.showClaimsList(source, faction);
                    return CommandResult.success();
                }
                Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
                if (!optionalPlayerFaction.isPresent()) {
                    throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
                }
                Faction playerFaction = optionalPlayerFaction.get();
                if (!faction.getName().equals(playerFaction.getName())) {
                    throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS}));
                }
                this.showClaimsList((CommandSource)player, playerFaction);
            } else {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS}));
            }
        }
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalFactionPlayer = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalFactionPlayer.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalFactionPlayer.get();
        this.showClaimsList((CommandSource)player, playerFaction);
        return CommandResult.success();
    }

    private void showClaimsList(CommandSource source, Faction faction) {
        ArrayList<Text> resultList = new ArrayList<Text>();
        Set<Claim> claims = faction.getClaims();
        for (Claim claim : claims) {
            Text.Builder claimHoverInfo = Text.builder();
            claimHoverInfo.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, "Accessible by faction: ", TextColors.RESET, claim.isAccessibleByFaction(), "\n"})});
            List ownersNames = claim.getOwners().stream().map(owner -> super.getPlugin().getPlayerManager().getFactionPlayer((UUID)owner)).filter(Optional::isPresent).map(factionPlayer -> ((FactionPlayer)factionPlayer.get()).getName()).collect(Collectors.toList());
            claimHoverInfo.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, "Owners: ", TextColors.RESET, String.join((CharSequence)", ", ownersNames)})});
            Text.Builder textBuilder = Text.builder();
            Optional world = Sponge.getServer().getWorld(claim.getWorldUUID());
            String worldName = "";
            if (world.isPresent()) {
                worldName = ((World)world.get()).getName();
            }
            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{"- ", TextColors.YELLOW, "World: ", TextColors.GREEN, worldName, TextColors.RESET, " | ", TextColors.YELLOW, "Chunk: ", TextColors.GREEN, claim.getChunkPosition()})}).onHover((HoverAction)TextActions.showText((Text)claimHoverInfo.build()));
            resultList.add(textBuilder.build());
        }
        PaginationList paginationList = PaginationList.builder().padding((Text)Text.of((String)"=")).title(Text.of((Object[])new Object[]{TextColors.YELLOW, "Claims List"})).contents(resultList).linesPerPage(10).build();
        paginationList.sendTo((MessageReceiver)source);
    }
}

