/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandList
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world list").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (arguments.equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        ArrayList<Text> list = new ArrayList<Text>();
        for (WorldProperties properties : Sponge.getServer().getAllWorldProperties()) {
            Optional optionalWorld = Sponge.getServer().getWorld(properties.getUniqueId());
            if (optionalWorld.isPresent()) {
                World world = (World)optionalWorld.get();
                Text.Builder builder = Text.builder().color(TextColors.GREEN).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.WHITE, "Click to view properies"})));
                builder.onClick((ClickAction)TextActions.runCommand((String)("/pjw:world properties " + world.getName()))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, world.getName(), ": ", Lists.newArrayList((Iterable)world.getLoadedChunks()).size(), " Loaded chunks, ", world.getEntities().size(), " Entities"})});
                list.add(builder.build());
                continue;
            }
            Text.Builder builder = Text.builder().color(TextColors.GREEN).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.WHITE, "Click to load world"})));
            builder.onClick((ClickAction)TextActions.runCommand((String)("/pjw:world load " + properties.getWorldName()))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, properties.getWorldName(), ": ", TextColors.GRAY, " Unloaded"})});
            list.add(builder.build());
        }
        if (source instanceof Player) {
            PaginationList.Builder pages = PaginationList.builder();
            pages.title(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Worlds"})}).build());
            pages.contents(list);
            pages.sendTo((MessageReceiver)source);
        } else {
            for (Text text : list) {
                source.sendMessage(text);
            }
        }
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        return new ArrayList<String>();
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

