/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;

public class BlockDecorLabeledCrate
extends BlockDecorDirectedHorizontal {
    public static void on_config(int stack_limit) {
    }

    public BlockDecorLabeledCrate(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new LabeledCrateTileEntity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213108, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof LabeledCrateTileEntity)) {
            return;
        }
        ((LabeledCrateTileEntity)te).readnbt(inventory_nbt);
        ((LabeledCrateTileEntity)te).func_70296_d();
    }

    private ItemStack itemize_with_inventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof LabeledCrateTileEntity)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound inventory_nbt = new NBTTagCompound();
        ItemStackHelper.func_191281_a((NBTTagCompound)inventory_nbt, ((LabeledCrateTileEntity)te).stacks_, (boolean)false);
        if (!inventory_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inventory", (NBTBase)inventory_nbt);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = this.itemize_with_inventory(world, pos);
        if (stack != ItemStack.field_190927_a) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
            world.func_175698_g(pos);
            world.func_175713_t(pos);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof LabeledCrateTileEntity)) {
            return;
        }
        for (ItemStack stack : ((LabeledCrateTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((LabeledCrateTileEntity)te).reset();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof LabeledCrateTileEntity ? new BContainer(player.field_71071_by, world, pos, (LabeledCrateTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof LabeledCrateTileEntity ? new BGui(player.field_71071_by, world, pos, (LabeledCrateTileEntity)te) : null;
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 55;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final LabeledCrateTileEntity te;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, LabeledCrateTileEntity te) {
            int x;
            int y;
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            int i = -1;
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 9; ++x) {
                    int xpos = 28 + x * 18;
                    int ypos = 10 + y * 18;
                    this.func_75146_a(new Slot((IInventory)te, ++i, xpos, ypos));
                }
            }
            this.func_75146_a(new Slot((IInventory)te, ++i, 191, 100){

                public int func_75219_a() {
                    return 1;
                }
            });
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 28 + x2 * 18, 183));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 28 + x * 18, 125 + y * 18));
                }
            }
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_75137_b(int id, int data) {
            this.te.func_174885_b(id, data);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorLabeledCrate && player.func_174818_b(this.pos) <= 64.0;
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return slot.func_75219_a() > 1;
        }

        public void func_75134_a(EntityPlayer player) {
            super.func_75134_a(player);
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 55) {
                if (!this.func_75135_a(slot_stack, 55, 91, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 55 && index <= 91) {
                if (!this.func_75135_a(slot_stack, 0, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    public static class LabeledCrateTileEntity
    extends TileEntity
    implements ISidedInventory {
        public static final int NUM_OF_FIELDS = 1;
        public static final int NUM_OF_SLOTS = 55;
        public static final int ITEMFRAME_SLOTNO = 54;
        protected NonNullList<ItemStack> stacks_ = NonNullList.func_191197_a((int)55, (Object)ItemStack.field_190927_a);
        private static final int[] SIDED_INV_SLOTS = new int[54];
        private final IItemHandler item_handler_ = new BItemHandler(this);

        public LabeledCrateTileEntity() {
            this.reset();
        }

        protected void reset() {
            this.stacks_ = NonNullList.func_191197_a((int)55, (Object)ItemStack.field_190927_a);
        }

        public void readnbt(NBTTagCompound compound) {
            NonNullList stacks = NonNullList.func_191197_a((int)55, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, (NonNullList)stacks);
            while (stacks.size() < 55) {
                stacks.add((Object)ItemStack.field_190927_a);
            }
            this.stacks_ = stacks;
        }

        protected void writenbt(NBTTagCompound compound) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks_);
        }

        public ItemStack getItemFrameStack() {
            return this.stacks_.size() > 54 ? (ItemStack)this.stacks_.get(54) : ItemStack.field_190927_a;
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorLabeledCrate);
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.readnbt(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            this.writenbt(compound);
            return compound;
        }

        public NBTTagCompound func_189517_E_() {
            NBTTagCompound nbt = super.func_189517_E_();
            this.writenbt(nbt);
            return nbt;
        }

        @Nullable
        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.readnbt(pkt.func_148857_g());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(NBTTagCompound tag) {
            this.func_145839_a(tag);
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.stacks_.set(index, (Object)stack);
            this.func_70296_d();
            if (!this.func_145831_w().field_72995_K) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 50);
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.func_174877_v().func_177951_i((Vec3i)player.func_180425_c()) < 36.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index != 54;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
            return true;
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return true;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.item_handler_;
            }
            return (T)super.getCapability(capability, facing);
        }

        static {
            for (int i = 0; i < SIDED_INV_SLOTS.length; ++i) {
                LabeledCrateTileEntity.SIDED_INV_SLOTS[i] = i;
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private LabeledCrateTileEntity te;

            BItemHandler(LabeledCrateTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 54;
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slotno, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (slotno < 0 || slotno >= 55 || slotno == 54) {
                    return ItemStack.field_190927_a;
                }
                ItemStack slotstack = this.getStackInSlot(slotno);
                if (!slotstack.func_190926_b()) {
                    if (slotstack.func_190916_E() >= Math.min(slotstack.func_77976_d(), this.getSlotLimit(slotno))) {
                        return stack;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotstack)) {
                        return stack;
                    }
                    if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                        return stack;
                    }
                    int n = Math.min(stack.func_77976_d(), this.getSlotLimit(slotno)) - slotstack.func_190916_E();
                    if (stack.func_190916_E() <= n) {
                        if (!simulate) {
                            ItemStack copy = stack.func_77946_l();
                            copy.func_190917_f(slotstack.func_190916_E());
                            this.te.func_70299_a(slotno, copy);
                        }
                        return ItemStack.field_190927_a;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        ItemStack copy = stack.func_77979_a(n);
                        copy.func_190917_f(slotstack.func_190916_E());
                        this.te.func_70299_a(slotno, copy);
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                    return stack;
                }
                int n = Math.min(stack.func_77976_d(), this.getSlotLimit(slotno));
                if (n < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        this.te.func_70299_a(slotno, stack.func_77979_a(n));
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!simulate) {
                    this.te.func_70299_a(slotno, stack);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                if (index < 0 || index >= 55 || index == 54) {
                    return ItemStack.field_190927_a;
                }
                if (!simulate) {
                    return ItemStackHelper.func_188382_a(this.te.stacks_, (int)index, (int)amount);
                }
                ItemStack stack = ((ItemStack)this.te.stacks_.get(index)).func_77946_l();
                if (stack.func_190916_E() > amount) {
                    stack.func_190920_e(amount);
                }
                return stack;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        private final LabeledCrateTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, LabeledCrateTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
            this.field_146999_f = 213;
            this.field_147000_g = 206;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/labeled_crate_gui.png"));
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_73729_b(x0, y0, 0, 0, w, h);
        }
    }
}

