/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.detail.ModAuxiliaries;
import wile.engineersdecor.detail.ModConfig;

public class BlockDecorHalfSlab
extends BlockDecor {
    public static final PropertyInteger PARTS = PropertyInteger.func_177719_a((String)"parts", (int)0, (int)14);
    protected static final AxisAlignedBB[] AABBs = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.125, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final int[] num_slabs_contained_in_parts_ = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 1};

    public BlockDecorHalfSlab(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound) {
        super(registryName, config, material, hardness, resistance, sound);
    }

    protected boolean is_cube(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PARTS) == 7;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (!ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true)) {
            return;
        }
        if (!ModConfig.optout.without_direct_slab_pickup) {
            ModAuxiliaries.Tooltip.addInformation("engineersdecor.tooltip.slabpickup", "engineersdecor.tooltip.slabpickup", tooltip, flag, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return (this.config & 0x80L) != 0L ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)14)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PARTS);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PARTS});
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return (this.config & 0x80L) == 0L && this.is_cube(state);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        int parts = (Integer)state.func_177229_b((IProperty)PARTS);
        switch (face) {
            case UP: {
                if (parts < 7) break;
                return BlockFaceShape.SOLID;
            }
            case DOWN: {
                if (parts > 7) break;
                return BlockFaceShape.SOLID;
            }
            default: {
                if (parts <= 5 || parts >= 10) break;
                return BlockFaceShape.SOLID;
            }
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBs[(Integer)state.func_177229_b((IProperty)PARTS) & 0xF];
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return this.is_cube(state);
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return this.is_cube(state);
    }

    public boolean func_189872_a(IBlockState state, Entity entity) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        BlockDecorHalfSlab.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), num_slabs_contained_in_parts_[(Integer)state.func_177229_b((IProperty)PARTS) & 0xF]));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_177230_c() != this;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(facing == EnumFacing.UP || facing != EnumFacing.DOWN && (double)hitY < 0.6 ? 0 : 14));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) != this) {
            return false;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return false;
        }
        int parts = (Integer)state.func_177229_b((IProperty)PARTS);
        if (facing != EnumFacing.UP && parts > 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts - 1)), 3);
        } else if (facing != EnumFacing.DOWN && parts < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts + 1)), 3);
        } else {
            return parts != 7;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
            if (player.field_71071_by != null) {
                player.field_71071_by.func_70296_d();
            }
        }
        SoundType st = this.getSoundType(state, world, pos, null);
        world.func_184133_a(null, pos, st.func_185841_e(), SoundCategory.BLOCKS, (st.func_185843_a() + 1.0f) / 2.5f, 0.9f * st.func_185847_b());
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K || ModConfig.optout.without_direct_slab_pickup) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) != this) {
            return;
        }
        if (stack.func_190916_E() >= stack.func_77976_d()) {
            return;
        }
        Vec3d lv = player.func_70040_Z();
        EnumFacing facing = EnumFacing.func_176737_a((float)((float)lv.field_72450_a), (float)((float)lv.field_72448_b), (float)((float)lv.field_72449_c));
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        int parts = (Integer)state.func_177229_b((IProperty)PARTS);
        if (facing == EnumFacing.DOWN && parts <= 7) {
            if (parts > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts - 1)), 3);
            } else {
                world.func_175698_g(pos);
            }
        } else if (facing == EnumFacing.UP && parts >= 7) {
            if (parts < 14) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts + 1)), 3);
            } else {
                world.func_175698_g(pos);
            }
        } else {
            return;
        }
        if (!player.func_184812_l_()) {
            stack.func_190917_f(1);
            if (player.field_71071_by != null) {
                player.field_71071_by.func_70296_d();
            }
        }
        SoundType st = this.getSoundType(state, world, pos, null);
        world.func_184133_a(player, pos, st.func_185841_e(), SoundCategory.BLOCKS, (st.func_185843_a() + 1.0f) / 2.5f, 0.9f * st.func_185847_b());
    }
}

