/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import net.kyori.adventure.nbt.LongBinaryTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LongBinaryTagImpl
implements LongBinaryTag {
    private final long value;

    LongBinaryTagImpl(long value) {
        this.value = value;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFFL);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFFL);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongBinaryTagImpl that = (LongBinaryTagImpl)other;
        return this.value == that.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public @NonNull String toString() {
        return "LongBinaryTagImpl{value=" + this.value + '}';
    }
}

