/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateMilkyWayRendererState;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargateMilkyWayMergeHelper;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateRendererActionState;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDMilkyWayTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.LinkingHelper;

public class StargateMilkyWayBaseTile
extends StargateClassicBaseTile
implements ILinkable {
    private BlockPos linkedDHD = null;
    private int linkId = -1;
    private BlockPos lastPos = BlockPos.field_177992_a;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).clearSymbols();
        }
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).activateSymbol(SymbolMilkyWayEnum.BRB);
        }
    }

    @Override
    public void activateDHDSymbolBRB() {
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).activateSymbol(SymbolMilkyWayEnum.BRB);
        }
    }

    @Override
    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).clearSymbols();
        }
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        DHDMilkyWayTile dhd;
        super.setConfig(config);
        if (this.isLinked() && (dhd = this.getLinkedDHD(this.field_145850_b)) != null) {
            DHDAbstractRendererState state = (DHDAbstractRendererState)dhd.getState(StateTypeEnum.RENDERER_STATE);
            state.gateConfig = this.getConfig();
            dhd.sendState(StateTypeEnum.RENDERER_STATE, state);
        }
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.MILKYWAY;
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface symbol) {
        this.stargateState = EnumStargateState.DIALING;
        this.func_70296_d();
        this.addSymbolToAddress(symbol);
        this.doIncomingAnimation(10, false);
        int plusTime = new Random().nextInt(5);
        if (this.stargateWillLock(symbol)) {
            this.isFinalActive = true;
            if (this.config.getOption(StargateClassicBaseTile.ConfigOptions.DHD_TOP_LOCK.id).getBooleanValue()) {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 5 + plusTime));
            } else {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10 + plusTime));
            }
        } else {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10 + plusTime));
        }
        this.sendSignal(null, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.isFinalActive, symbol.getEnglishName());
        this.func_70296_d();
    }

    @Override
    protected int getMaxChevrons() {
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && !this.getLinkedDHD(this.field_145850_b).hasUpgrade(DHDAbstractTile.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        super.addSymbolToAddress(symbol);
        DHDMilkyWayTile dhd = this.getLinkedDHD(this.field_145850_b);
        if (this.isLinkedAndDHDOperational() && dhd != null) {
            ((DHDAbstractTile)dhd).activateSymbol((SymbolMilkyWayEnum)symbol);
        }
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, Object context) {
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        super.addSymbolToAddressManual(targetSymbol, context);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, 400);
        this.func_70296_d();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, time);
        this.func_70296_d();
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        super.startIncomingAnimation(addressSize, period);
        this.incomingPeriod -= (int)Math.round(20.0 / (double)addressSize);
        if (this.config.getOption(StargateClassicBaseTile.ConfigOptions.SPIN_GATE_INCOMING.id).getBooleanValue() && this.incomingPeriod > 9) {
            this.spinRing(1, false, true, this.incomingPeriod * addressSize);
        }
        this.func_70296_d();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        super.lightUpChevronByIncoming(disableAnimation);
        if (this.incomingPeriod == -1) {
            return;
        }
        if (!disableAnimation) {
            if (this.stargateState.idle()) {
                this.stargateState = EnumStargateState.IDLE;
                this.func_70296_d();
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
                this.resetIncomingAnimation();
                this.func_70296_d();
                return;
            }
            if (this.incomingLastChevronLightUp >= this.incomingAddressSize) {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 1));
                this.resetIncomingAnimation();
                this.func_70296_d();
                return;
            }
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, this.incomingLastChevronLightUp + 9, false);
        } else {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, this.incomingAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.resetIncomingAnimation();
            this.func_70296_d();
        }
        this.func_70296_d();
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        if (this.isLinked()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
            this.getLinkedDHD(this.field_145850_b).setLinkedGate(null, -1);
            this.setLinkedDHD(null, -1);
        }
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargateMilkyWayMergeHelper.INSTANCE;
    }

    @Nullable
    public DHDMilkyWayTile getLinkedDHD(World world) {
        if (this.linkedDHD == null) {
            return null;
        }
        return (DHDMilkyWayTile)world.func_175625_s(this.linkedDHD);
    }

    public boolean isLinked() {
        return this.linkedDHD != null && this.field_145850_b.func_175625_s(this.linkedDHD) instanceof DHDMilkyWayTile;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDMilkyWayTile dhdMilkyWayTile = this.getLinkedDHD(this.field_145850_b);
        return dhdMilkyWayTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
        this.linkedDHD = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        if (!this.isMerged()) {
            return;
        }
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), JSGBlocks.DHD_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestDhd != null) {
            DHDMilkyWayTile dhdMilkyWayTile = (DHDMilkyWayTile)this.field_145850_b.func_175625_s(closestDhd);
            dhdMilkyWayTile.setLinkedGate(this.field_174879_c, linkId);
            this.setLinkedDHD(closestDhd, linkId);
            this.func_70296_d();
        }
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.isLinked()) {
            compound.func_74772_a("linkedDHD", this.linkedDHD.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedDHD")) {
            this.linkedDHD = BlockPos.func_177969_a((long)compound.func_74763_f("linkedDHD"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        super.func_145839_a(compound);
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedDHD(null, -1);
        return super.prepare(sender, command);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.MILKYWAY_RING_ROLL;
            }
            case GATE_RING_ROLL_START: {
                return SoundPositionedEnum.MILKYWAY_RING_ROLL_START;
            }
        }
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_MILKYWAY_CLOSE;
            }
            case DIAL_FAILED: {
                return this.stargateState.dialingComputer() ? SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED_COMPUTER : SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_MILKYWAY_INCOMING;
            }
            case CHEVRON_OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_CHEVRON_OPEN;
            }
            case CHEVRON_SHUT: {
                return SoundEventEnum.GATE_MILKYWAY_CHEVRON_SHUT;
            }
        }
        return null;
    }

    @Override
    protected boolean onGateMergeRequested() {
        if (this.stargateSize != JSGConfig.Stargate.stargateSize) {
            StargateMilkyWayMergeHelper.INSTANCE.convertToPattern(this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical, this.stargateSize, JSGConfig.Stargate.stargateSize);
            this.stargateSize = JSGConfig.Stargate.stargateSize;
        }
        return StargateMilkyWayMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && !this.lastPos.equals((Object)this.field_174879_c)) {
            this.lastPos = this.field_174879_c;
            this.updateLinkStatus();
            this.func_70296_d();
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder getRendererStateServer() {
        return (StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder)new StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargateMilkyWayRendererState();
    }

    @Override
    public StargateMilkyWayRendererState getRendererStateClient() {
        return (StargateMilkyWayRendererState)super.getRendererStateClient();
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return super.createState(stateType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null && stateType == StateTypeEnum.RENDERER_UPDATE) {
            StargateRendererActionState gateActionState = (StargateRendererActionState)state;
            switch (gateActionState.action) {
                case CHEVRON_OPEN: {
                    this.getRendererStateClient().openChevron(this.field_145850_b.func_82737_E());
                    break;
                }
                case CHEVRON_CLOSE: {
                    this.getRendererStateClient().closeChevron(this.field_145850_b.func_82737_E());
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        boolean onlySpin = false;
        if (customData != null && customData.func_74764_b("onlySpin")) {
            onlySpin = customData.func_74767_n("onlySpin");
        }
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.func_70296_d();
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (!onlySpin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 7));
                } else if (this.stargateState.dialingComputer()) {
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.func_70296_d();
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateWillLock(this.targetRingSymbol)) {
                        if (this.checkAddressAndEnergy(this.dialedAddress).ok()) {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 13));
                            break;
                        }
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                        break;
                    }
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 3));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                    return;
                }
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                } else {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE_BOTH, 0, false);
                }
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateState.incoming() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                    if (this.stargateState.dialingDHD()) {
                        this.stargateState = EnumStargateState.IDLE;
                    }
                    this.func_70296_d();
                    return;
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), true, this.targetRingSymbol.getEnglishName());
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 10));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_DIM, 0, false);
                this.stargateState = EnumStargateState.IDLE;
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName());
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public int getDefaultCapacitors() {
        return 3;
    }
}

