/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.api.event.StargateChevronEngagedEvent;
import tauri.dev.jsg.api.event.StargateClosedEvent;
import tauri.dev.jsg.api.event.StargateClosingEvent;
import tauri.dev.jsg.api.event.StargateDialFailEvent;
import tauri.dev.jsg.api.event.StargateOpenedEvent;
import tauri.dev.jsg.api.event.StargateOpeningEvent;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.block.dialhomedevice.DHDBlock;
import tauri.dev.jsg.chunkloader.ChunkManager;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.JSGConfigUtil;
import tauri.dev.jsg.config.stargate.StargateDimensionConfig;
import tauri.dev.jsg.config.stargate.StargateTimeLimitModeEnum;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.particle.ParticleWhiteSmoke;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateEnergyRequired;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.AutoCloseManager;
import tauri.dev.jsg.stargate.EnumIrisState;
import tauri.dev.jsg.stargate.EnumIrisType;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.StargateClosedReasonEnum;
import tauri.dev.jsg.stargate.StargateOpenResult;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.StargateNetwork;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.internalgates.StargateAddressesEnum;
import tauri.dev.jsg.stargate.teleportation.EventHorizon;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateFlashState;
import tauri.dev.jsg.state.stargate.StargateRendererActionState;
import tauri.dev.jsg.state.stargate.StargateVaporizeBlockParticlesRequest;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateOrlinBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.tileentity.util.PreparableInterface;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.tileentity.util.ScheduledTaskExecutorInterface;
import tauri.dev.jsg.util.JSGAdvancementsUtil;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.main.JSGProps;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.WirelessEndpoint", modid="opencomputers")})
public abstract class StargateAbstractBaseTile
extends TileEntity
implements StateProviderInterface,
ITickable,
ICapabilityProvider,
ScheduledTaskExecutorInterface,
Environment,
WirelessEndpoint,
PreparableInterface {
    protected EnumStargateState stargateState = EnumStargateState.IDLE;
    private boolean isInitiating;
    private BlockPos lastPos = BlockPos.field_177992_a;
    protected EventHorizon eventHorizon;
    private AutoCloseManager autoCloseManager;
    protected Map<SymbolTypeEnum, StargateAddress> gateAddressMap = new HashMap<SymbolTypeEnum, StargateAddress>(3);
    protected Map<SymbolTypeEnum, StargatePos> gatePosMap = new HashMap<SymbolTypeEnum, StargatePos>(3);
    protected StargateAddressDynamic dialedAddress = new StargateAddressDynamic(this.getSymbolType());
    protected StargatePos targetGatePos;
    public boolean connectedToGate = false;
    protected boolean connectingToGate = false;
    protected StargatePos connectedToGatePos;
    protected boolean isIncoming = false;
    protected NetworkRegistry.TargetPoint targetPoint;
    protected EnumFacing facing = EnumFacing.NORTH;
    protected StargateNetwork network;
    protected EnumFacing facingVertical = EnumFacing.SOUTH;
    private boolean addedToNetwork;
    public int randomIncomingEntities = 0;
    public int randomIncomingAddrSize = 7;
    public int randomIncomingOpenDelay = 0;
    public float randomIncomingState = 0.0f;
    public boolean randomIncomingIsActive = false;
    protected List<JSGAxisAlignedBB> localKillingBoxes;
    protected List<JSGAxisAlignedBB> localInnerBlockBoxes;
    protected List<JSGAxisAlignedBB> localInnerEntityBoxes;
    protected boolean horizonKilling = false;
    protected int horizonSegments = 0;
    private AxisAlignedBB renderBoundingBox = TileEntity.INFINITE_EXTENT_AABB;
    StargateAbstractRendererState rendererStateClient;
    private boolean isMerged;
    public final HashMap<Integer, Entity> entitiesPassedLast = new HashMap();
    private ScheduledTask horizonFlashTask;
    private int flashIndex = 0;
    public boolean isCurrentlyUnstable = false;
    protected List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    protected ScheduledTask lastSpinFinished;
    private int keepAliveEnergyPerTick = 0;
    private int shieldKeepAlive = 0;
    private int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    protected float energySecondsToClose = 0.0f;
    public long openedSince;
    private final Node node = JSG.ocWrapper.createNode(this, "stargate");

    public StargateNetwork getNetwork() {
        if (this.network == null) {
            this.network = StargateNetwork.get(this.field_145850_b);
        }
        return this.network;
    }

    public final EnumStargateState getStargateState() {
        return this.stargateState;
    }

    protected void engageGate() {
        this.stargateState = this.isInitiating ? EnumStargateState.ENGAGED_INITIATING : EnumStargateState.ENGAGED;
        this.eventHorizon.reset();
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, true);
        if (this.targetGatePos != null) {
            new StargateOpenedEvent(this, this.targetGatePos.getTileEntity(), this.isInitiating).post();
        } else if (this.randomIncomingIsActive) {
            new StargateOpenedEvent(this, this, this.isInitiating).post();
        }
        this.sendSignal(null, "stargate_wormhole_stabilized", this.isInitiating);
        this.func_70296_d();
    }

    protected void disconnectGate(boolean force) {
        this.disconnectGate();
        if (force) {
            this.stargateState = EnumStargateState.IDLE;
        }
        this.func_70296_d();
    }

    protected void disconnectGate() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.stargateState = EnumStargateState.IDLE;
        } else {
            this.isIncoming = false;
        }
        this.getAutoCloseManager().reset();
        if (!(this instanceof StargateOrlinBaseTile)) {
            this.dialedAddress.clear();
        }
        new StargateClosedEvent(this).post();
        ChunkManager.unforceChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
        this.sendSignal(null, "stargate_wormhole_closed_fully", this.isInitiating);
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.func_70296_d();
    }

    protected void failGate() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.stargateState = EnumStargateState.IDLE;
        }
        this.connectedToGate = false;
        this.connectingToGate = false;
        if (!(this instanceof StargateOrlinBaseTile)) {
            this.dialedAddress.clear();
        }
        this.func_70296_d();
    }

    public void onBlockBroken() {
        for (StargateAddress address : this.gateAddressMap.values()) {
            this.getNetwork().removeStargate(address);
        }
    }

    protected void onGateBroken() {
        this.field_145850_b.func_175698_g(this.getGateCenterPos());
        this.resetTargetIncomingAnimation();
        if (this.stargateState.initiating() || this.stargateState.engaged() && this.targetGatePos == null) {
            this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
        } else if (this.stargateState.engaged()) {
            this.targetGatePos.getTileEntity().attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
        }
        this.dialedAddress.clear();
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.targetGatePos = null;
        this.scheduledTasks.clear();
        this.stargateState = EnumStargateState.IDLE;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
        ChunkManager.unforceChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, false);
        this.func_70296_d();
    }

    protected void onGateMerged() {
    }

    public boolean canAcceptConnectionFrom(StargatePos targetGatePos) {
        boolean allowConnectToDialing = JSGConfig.Stargate.mechanics.allowConnectToDialing;
        if (allowConnectToDialing) {
            if (this.isMerged) {
                switch (this.stargateState) {
                    case IDLE: 
                    case DIALING: 
                    case DIALING_COMPUTER: 
                    case INCOMING: {
                        return true;
                    }
                }
                return false;
            }
        } else {
            return this.isMerged && (this.stargateState.idle() || this.stargateState.incoming());
        }
        return false;
    }

    protected void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal, EnumIrisType irisType, EnumIrisState irisState, long irisAnimation) {
        this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal, irisType, irisState, irisAnimation));
    }

    protected void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal) {
        this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal));
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    public JSGAxisAlignedBB getEventHorizonLocalBox() {
        return this.eventHorizon.getLocalBox();
    }

    protected abstract JSGAxisAlignedBB getHorizonTeleportBox(boolean var1);

    private AutoCloseManager getAutoCloseManager() {
        if (this.autoCloseManager == null) {
            this.autoCloseManager = new AutoCloseManager(this);
        }
        return this.autoCloseManager;
    }

    public void setMotionOfPassingEntity(int entityId, Vector2f motionVector) {
        this.eventHorizon.setMotion(entityId, motionVector);
    }

    public void teleportEntity(int entityId) {
        this.eventHorizon.teleportEntity(entityId);
    }

    public void removeEntity(int entityId) {
        this.eventHorizon.removeEntity(entityId);
    }

    public StargateOpenResult attemptOpenAndFail() {
        ResultTargetValid resultTarget = this.attemptOpenDialed();
        if (resultTarget == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!resultTarget.result.ok()) {
            this.dialingFailed(resultTarget.result);
            if (resultTarget.targetVaild && this.getNetwork().getStargate(this.dialedAddress) != null && this.getNetwork().getStargate(this.dialedAddress).getTileEntity() != null) {
                this.getNetwork().getStargate(this.dialedAddress).getTileEntity().dialingFailed(StargateOpenResult.CALLER_HUNG_UP);
            }
        }
        return resultTarget.result;
    }

    protected ResultTargetValid attemptOpenDialed() {
        boolean targetValid = false;
        StargateOpenResult result = this.checkAddressAndEnergy(this.dialedAddress);
        if (result.ok()) {
            targetValid = true;
            StargatePos targetGatePos = this.getNetwork().getStargate(this.dialedAddress);
            StargateAbstractBaseTile targetTile = targetGatePos.getTileEntity();
            if (new StargateOpeningEvent(this, targetGatePos.getTileEntity(), this.isInitiating).post()) {
                return new ResultTargetValid(StargateOpenResult.ABORTED_BY_EVENT, targetValid);
            }
            if (!targetTile.canAcceptConnectionFrom(this.gatePosMap.get(this.getSymbolType()))) {
                return new ResultTargetValid(StargateOpenResult.ADDRESS_MALFORMED, targetValid);
            }
            JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_OPEN);
            this.openGate(targetGatePos, true);
            targetTile.openGate(this.gatePosMap.get(targetGatePos.symbolType), false);
            targetTile.dialedAddress.clear();
            targetTile.dialedAddress.addAll(this.gateAddressMap.get(targetGatePos.symbolType).subList(0, this.dialedAddress.size() - 1));
            targetTile.dialedAddress.addOrigin();
        }
        return new ResultTargetValid(result, targetValid);
    }

    protected StargateOpenResult checkAddress(StargateAddressDynamic address) {
        if (!address.validate()) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!this.canDialAddress(address)) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        StargateAbstractBaseTile targetTile = this.getNetwork().getStargate(address).getTileEntity();
        if (!targetTile.canAcceptConnectionFrom(this.gatePosMap.get(this.getSymbolType()))) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        return StargateOpenResult.OK;
    }

    public StargateOpenResult checkAddressAndEnergy(StargateAddressDynamic address) {
        StargateClassicBaseTile classicTile;
        StargateOpenResult result = this.checkAddress(address);
        if (!result.ok()) {
            return result;
        }
        StargatePos targetGatePos = this.getNetwork().getStargate(address);
        if (targetGatePos == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!this.hasEnergyToDial(targetGatePos)) {
            return StargateOpenResult.NOT_ENOUGH_POWER;
        }
        StargateAbstractBaseTile targetTile = targetGatePos.getTileEntity();
        if (targetTile instanceof StargateClassicBaseTile && (classicTile = (StargateClassicBaseTile)targetTile).isGateBurried()) {
            return StargateOpenResult.GATE_BURRIED;
        }
        return StargateOpenResult.OK;
    }

    protected boolean canDialAddress(StargateAddressDynamic address) {
        StargatePos targetGatePos = this.getNetwork().getStargate(address);
        if (targetGatePos == null) {
            return false;
        }
        if (targetGatePos.equals(this.gatePosMap.get(this.getSymbolType()))) {
            return false;
        }
        if (this.checkAddressLength(address, targetGatePos)) {
            return false;
        }
        int additional = address.size() - 7;
        return additional <= 0 || address.getAdditional().subList(0, additional).equals(targetGatePos.additionalSymbols.subList(0, additional));
    }

    protected boolean checkAddressLength(StargateAddressDynamic address, StargatePos targetGatePosition) {
        if (targetGatePosition == null) {
            return false;
        }
        boolean localDial = this.field_145850_b.field_73011_w.getDimension() == targetGatePosition.dimensionID || StargateDimensionConfig.isGroupEqual(this.field_145850_b.field_73011_w.func_186058_p(), DimensionManager.getProviderType((int)targetGatePosition.dimensionID));
        return address.size() < this.getSymbolType().getMinimalSymbolCountTo(targetGatePosition.getTileEntity().getSymbolType(), localDial);
    }

    public void attemptClose(StargateClosedReasonEnum reason) {
        if (reason == null) {
            return;
        }
        if (this.targetGatePos == null) {
            this.closeGate(reason);
            this.resetRandomIncoming();
            return;
        }
        if ((new StargateClosingEvent(this, this.targetGatePos.getTileEntity(), this.isInitiating, reason).post() || new StargateClosingEvent(this.targetGatePos.getTileEntity(), this, !this.isInitiating, reason).post()) && reason.equals((Object)StargateClosedReasonEnum.REQUESTED)) {
            return;
        }
        if (this.targetGatePos != null) {
            this.targetGatePos.getTileEntity().closeGate(reason);
        }
        this.closeGate(reason);
    }

    public abstract SymbolTypeEnum getSymbolType();

    @Nullable
    public StargateAddress getStargateAddress(SymbolTypeEnum symbolType) {
        if (this.gateAddressMap == null) {
            return null;
        }
        return this.gateAddressMap.get(symbolType);
    }

    public void setGateAddress(SymbolTypeEnum symbolType, StargateAddress stargateAddress) {
        this.getNetwork().removeStargate(this.gateAddressMap.get(symbolType));
        StargatePos gatePos = new StargatePos(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, stargateAddress);
        this.gateAddressMap.put(symbolType, stargateAddress);
        this.gatePosMap.put(symbolType, gatePos);
        this.getNetwork().addStargate(stargateAddress, gatePos);
        this.func_70296_d();
    }

    public void refresh() {
        this.setGateAddress(this.getSymbolType(), this.getStargateAddress(this.getSymbolType()));
        this.updateFacing((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL), (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_VERTICAL), true);
    }

    public StargateAddressDynamic getDialedAddress() {
        return this.dialedAddress;
    }

    protected int getMaxChevrons() {
        return 7;
    }

    protected boolean stargateWillLock(SymbolInterface symbol, boolean notAddedYet) {
        if (this.dialedAddress.size() + (notAddedYet ? 1 : 0) == this.getMaxChevrons()) {
            return true;
        }
        return this.dialedAddress.size() + (notAddedYet ? 1 : 0) >= 7 && symbol.origin();
    }

    protected boolean stargateWillLock(SymbolInterface symbol) {
        return this.stargateWillLock(symbol, false);
    }

    public boolean canAddSymbol(SymbolInterface symbol) {
        return this.canAddSymbolInternal(symbol) && !new StargateChevronEngagedEvent(this, symbol, this.stargateWillLock(symbol)).post();
    }

    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        return this.dialedAddress.size() < this.getMaxChevrons();
    }

    protected void addSymbolToAddress(SymbolInterface symbol, int addSymbol) {
        if (!this.canAddSymbol(symbol)) {
            throw new IllegalStateException("Cannot add that symbol");
        }
        if (addSymbol == 1) {
            this.dialedAddress.addSymbol(symbol);
        }
        StargateAddressDynamic dialAddr_backup = new StargateAddressDynamic(this.getSymbolType());
        dialAddr_backup.clear();
        dialAddr_backup.addAll(this.dialedAddress);
        if (symbol != this.getSymbolType().getOrigin() && this.dialedAddress.size() >= 6) {
            StargateAbstractBaseTile targetTile;
            this.dialedAddress.addOrigin();
            if (this.checkAddressAndEnergy(this.dialedAddress).ok() && !this.connectedToGate && !Objects.requireNonNull(this.getNetwork().getStargate((StargateAddress)this.dialedAddress)).getTileEntity().stargateState.incoming()) {
                this.connectingToGate = true;
            } else if (!this.checkAddressAndEnergy(this.dialedAddress).ok() && this.connectedToGate && (targetTile = Objects.requireNonNull(this.getNetwork().getStargate(this.dialedAddress)).getTileEntity()) != null) {
                targetTile.disconnectGate(true);
                targetTile.stargateState = EnumStargateState.IDLE;
                targetTile.func_70296_d();
            }
            this.dialedAddress.clear();
            this.dialedAddress.addAll(dialAddr_backup);
        }
        this.func_70296_d();
    }

    protected void addSymbolToAddress(SymbolInterface symbol) {
        if (StargateAddressesEnum.tryDialInternal(this, symbol)) {
            this.addSymbolToAddress(symbol, 0);
        } else {
            this.addSymbolToAddress(symbol, 1);
        }
    }

    protected void resetTargetIncomingAnimation() {
        if (this.connectedToGatePos != null) {
            StargateAbstractBaseTile targetGateTile = this.connectedToGatePos.getTileEntity();
            targetGateTile.disconnectGate(true);
            targetGateTile.stargateState = EnumStargateState.IDLE;
            targetGateTile.func_70296_d();
            this.connectedToGatePos = null;
            this.connectedToGate = false;
            this.connectingToGate = false;
            this.func_70296_d();
        }
    }

    protected void doIncomingAnimation(int time, boolean byComputer) {
        this.doIncomingAnimation(time, byComputer, null);
    }

    protected void doIncomingAnimation(int time, boolean byComputer, SymbolInterface symbol) {
        if (!this.connectingToGate) {
            return;
        }
        this.connectingToGate = false;
        this.func_70296_d();
        StargateAddressDynamic dialAddr_backup = new StargateAddressDynamic(this.getSymbolType());
        dialAddr_backup.clear();
        dialAddr_backup.addAll(this.dialedAddress);
        if (this.dialedAddress.size() >= 6 && (symbol == null || symbol.origin())) {
            this.dialedAddress.addOrigin();
            StargatePos targetGatePos = this.getNetwork().getStargate(this.dialedAddress);
            if (targetGatePos == null) {
                return;
            }
            StargateAbstractBaseTile targetGateTile = targetGatePos.getTileEntity();
            if (targetGateTile == null) {
                return;
            }
            if (this.checkAddressAndEnergy(this.dialedAddress).ok() && !this.connectedToGate) {
                int size = this.dialedAddress.size();
                this.connectedToGate = true;
                this.connectedToGatePos = targetGatePos;
                this.func_70296_d();
                int period = 400;
                if (byComputer) {
                    period = (time += 20) / 20 * 1000 / size;
                }
                targetGateTile.isIncoming = true;
                targetGateTile.func_70296_d();
                if (targetGateTile instanceof StargateClassicBaseTile && ((StargateClassicBaseTile)targetGateTile).config.getOption(StargateClassicBaseTile.ConfigOptions.ALLOW_INCOMING.id).getBooleanValue()) {
                    targetGateTile.incomingWormhole(size, period);
                } else {
                    targetGateTile.incomingWormhole(size);
                }
                targetGateTile.sendSignal(null, "stargate_incoming_wormhole", size);
                targetGateTile.stargateState = EnumStargateState.INCOMING;
                targetGateTile.func_70296_d();
                targetGateTile.failGate();
            } else if (!this.checkAddressAndEnergy(this.dialedAddress).ok() && this.connectedToGate) {
                targetGateTile.disconnectGate(true);
                targetGateTile.stargateState = EnumStargateState.IDLE;
                targetGateTile.func_70296_d();
                this.connectedToGatePos = null;
                this.func_70296_d();
            }
            this.dialedAddress.clear();
            this.dialedAddress.addAll(dialAddr_backup);
        }
    }

    protected boolean isConnected() {
        return this.connectedToGate;
    }

    public void incomingWormhole(int dialedAddressSize) {
        this.dialedAddress.clear();
        this.sendSignal(null, "stargate_incoming_wormhole", dialedAddressSize);
    }

    public void incomingWormhole(int dialedAddressSize, int time) {
        this.isIncoming = true;
        this.incomingWormhole(dialedAddressSize);
        this.func_70296_d();
    }

    protected int getOpenSoundDelay() {
        return EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks;
    }

    protected void openGate(StargatePos targetGatePos, boolean isInitiating) {
        this.setOpenedSince();
        this.isInitiating = isInitiating;
        this.targetGatePos = targetGatePos;
        this.stargateState = EnumStargateState.UNSTABLE;
        ChunkManager.forceChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, false);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_SOUND, this.getOpenSoundDelay()));
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 19 + this.getTicksPerHorizonSegment(true)));
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 23 + this.getTicksPerHorizonSegment(true)));
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ENGAGE));
        if (isInitiating) {
            StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(targetGatePos);
            this.getEnergyStorage().extractEnergy(energyRequired.energyToOpen, false);
            this.keepAliveEnergyPerTick = energyRequired.keepAlive;
        }
        this.sendSignal(null, "stargate_open", isInitiating);
        JSG.debug("Gate at " + this.field_174879_c.toString() + " opened!");
        this.func_70296_d();
    }

    protected void closeGate(StargateClosedReasonEnum reason) {
        this.stargateState = EnumStargateState.UNSTABLE;
        this.energySecondsToClose = 0.0f;
        this.resetOpenedSince();
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CLOSE, 62));
        this.playSoundEvent(StargateSoundEventEnum.CLOSE);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLOSE_GATE, 0, false);
        this.sendSignal(null, "stargate_close", reason.toString().toLowerCase());
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, false);
        if (this.isInitiating) {
            this.horizonFlashTask = null;
            this.isCurrentlyUnstable = false;
            this.updateFlashState(false);
        }
        this.targetGatePos = null;
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.connectedToGatePos = null;
        this.isIncoming = false;
        JSG.debug("Gate at " + this.field_174879_c.toString() + " closed!");
        this.func_70296_d();
    }

    protected void dialingFailed(StargateOpenResult reason) {
        if (this.stargateState == EnumStargateState.DIALING || this.stargateState == EnumStargateState.DIALING_COMPUTER || this.stargateState == EnumStargateState.IDLE) {
            if (this.connectedToGate) {
                if (this instanceof StargateClassicBaseTile) {
                    this.dialedAddress.addSymbol(this.getSymbolType().getOrigin());
                }
                Objects.requireNonNull(this.getNetwork().getStargate(this.dialedAddress)).getTileEntity().disconnectGate();
            }
            this.sendSignal(null, "stargate_failed", reason.toString().toLowerCase());
            this.horizonFlashTask = null;
            new StargateDialFailEvent(this, reason).post();
            this.addFailedTaskAndPlaySound();
            if (this.stargateState != EnumStargateState.INCOMING) {
                this.stargateState = EnumStargateState.FAILING;
            }
            JSG.debug("Gate at " + this.field_174879_c.toString() + " failed!");
            this.func_70296_d();
        }
    }

    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, 53));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    protected boolean verifyConnection() {
        if (!(this.targetGatePos != null && this.targetGatePos.getTileEntity() instanceof StargateAbstractBaseTile || this.randomIncomingIsActive)) {
            this.closeGate(StargateClosedReasonEnum.CONNECTION_LOST);
            return false;
        }
        return true;
    }

    @Nullable
    protected abstract SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum var1);

    @Nullable
    protected abstract SoundEventEnum getSoundEvent(StargateSoundEventEnum var1);

    public void playPositionedSound(StargateSoundPositionedEnum soundEnum, boolean play) {
        SoundPositionedEnum positionedSound = this.getPositionedSound(soundEnum);
        if (positionedSound == null) {
            throw new IllegalArgumentException("Tried to play " + (Object)((Object)soundEnum) + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        if (this.field_145850_b.field_72995_K) {
            JSG.proxy.playPositionedSoundClientSide(this.getGateCenterPos(), positionedSound, play);
        } else {
            JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), positionedSound, play);
        }
    }

    public void playPositionedSoundServer(StargateSoundPositionedEnum soundEnum, boolean play) {
        SoundPositionedEnum positionedSound = this.getPositionedSound(soundEnum);
        if (positionedSound == null) {
            throw new IllegalArgumentException("Tried to play " + (Object)((Object)soundEnum) + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), positionedSound, play);
    }

    public void playSoundEvent(StargateSoundEventEnum soundEnum) {
        SoundEventEnum soundEvent = this.getSoundEvent(soundEnum);
        if (soundEvent == null) {
            throw new IllegalArgumentException("Tried to play " + (Object)((Object)soundEnum) + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        if (this.field_145850_b.field_72995_K) {
            JSGSoundHelper.playSoundEventClientSide(this.field_145850_b, this.getGateCenterPos(), soundEvent);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), soundEvent);
        }
    }

    public void playSoundEvent(SoundEventEnum soundEnum) {
        if (soundEnum == null) {
            throw new IllegalArgumentException("Tried to play " + soundEnum + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        if (this.field_145850_b.field_72995_K) {
            JSGSoundHelper.playSoundEventClientSide(this.field_145850_b, this.getGateCenterPos(), soundEnum);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), soundEnum);
        }
    }

    public abstract BlockPos getGateCenterPos();

    public EnumFacing getFacing() {
        return this.facing;
    }

    public EnumFacing getFacingVertical() {
        return this.facingVertical;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.lastPos = this.field_174879_c;
            this.updateFacing((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL), (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_VERTICAL), true);
            this.network = StargateNetwork.get(this.field_145850_b);
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
            this.generateAddresses(false);
            if (this.stargateState.engaged()) {
                this.verifyConnection();
            }
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        }
    }

    public void generateAddresses(boolean reset) {
        Random random = new Random(this.field_174879_c.hashCode() * 31 + this.field_145850_b.field_73011_w.getDimension());
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            StargateAddress address = this.getStargateAddress(symbolType);
            if (this.gateAddressMap.get(symbolType) == null || reset) {
                address = new StargateAddress(symbolType);
                address.generate(random);
            }
            this.setGateAddress(symbolType, address);
        }
    }

    public void generateIncoming(int entities, int addressSize) {
        this.generateIncoming(entities, addressSize, 80 + new Random().nextInt(120));
    }

    public void generateIncoming(int entities, int addressSize, int delay) {
        if (!this.isMerged) {
            return;
        }
        if (this instanceof StargateUniverseBaseTile && (!this.stargateState.idle() && (!this.stargateState.dialing() || this.stargateState.dialingComputer()) || this.randomIncomingIsActive)) {
            return;
        }
        if (!this.stargateState.idle() && !this.stargateState.dialing() || this.randomIncomingIsActive) {
            return;
        }
        if (this.stargateState.incoming()) {
            return;
        }
        this.randomIncomingEntities = entities;
        this.randomIncomingAddrSize = addressSize;
        this.randomIncomingOpenDelay = delay;
        this.randomIncomingState = 0.0f;
        this.randomIncomingIsActive = true;
    }

    public void resetRandomIncoming() {
        this.randomIncomingIsActive = false;
        this.randomIncomingEntities = 0;
        this.randomIncomingState = 0.0f;
        this.randomIncomingAddrSize = 7;
        this.randomIncomingOpenDelay = 0;
    }

    public void activateDHDSymbolBRB() {
    }

    public void func_73660_a() {
        ScheduledTask.iterate(this.scheduledTasks, this.field_145850_b.func_82737_E());
        if (!this.field_145850_b.field_72995_K) {
            StargateAbstractBaseTile tile;
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
                JSG.ocWrapper.joinWirelessNetwork(this);
                JSG.ocWrapper.joinOrCreateNetwork(this);
            }
            if (this.targetPoint == null) {
                this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
                this.func_70296_d();
            }
            if (this.stargateState.engaged() && this.targetGatePos == null && !this.randomIncomingIsActive) {
                JSG.error("A stargateState indicates the Gate should be open, but targetGatePos is null. This is a bug. Closing gate...");
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
            }
            this.updatePassedEntities();
            if (this.stargateState.initiating()) {
                this.eventHorizon.scheduleTeleportation(this.targetGatePos, true);
            } else if (this.stargateState.engaged()) {
                this.eventHorizon.scheduleTeleportation(this.targetGatePos, false);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L && this.stargateState == EnumStargateState.ENGAGED && JSGConfig.Stargate.autoClose.autocloseEnabled && this.shouldAutoclose()) {
                if (this.targetGatePos != null) {
                    this.targetGatePos.getTileEntity().attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                } else {
                    this.attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                }
            }
            if (this.horizonFlashTask != null && this.horizonFlashTask.isActive()) {
                this.horizonFlashTask.update(this.field_145850_b.func_82737_E());
            }
            if (this.targetGatePos != null && this.field_145850_b.func_82737_E() % 80L == 0L && this.stargateState.engaged() && (tile = this.targetGatePos.getTileEntity()) != null && tile.stargateState.idle()) {
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
            }
            this.kawooshDestruction();
            if (this.stargateState.initiating()) {
                if (this.targetGatePos == null) {
                    this.targetGatePos = this.getNetwork().getStargate(this.getStargateAddress(SymbolTypeEnum.MILKYWAY));
                }
                int energyStored = this.getEnergyStorage().getEnergyStored();
                int morePower = this.doTimeLimitFunc();
                this.energySecondsToClose = (float)energyStored / (float)(this.keepAliveEnergyPerTick + morePower + this.shieldKeepAlive) / 20.0f;
                if (this.energySecondsToClose >= 1.0f) {
                    if (this.horizonFlashTask == null && this.energySecondsToClose < (float)JSGConfig.Stargate.power.instabilitySeconds && this.energyTransferedLastTick < 0) {
                        this.resetFlashingSequence();
                        this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 40.0) + 5));
                    }
                    if (this.horizonFlashTask != null && (this.energySecondsToClose > (float)JSGConfig.Stargate.power.instabilitySeconds || this.energyTransferedLastTick >= 0)) {
                        this.horizonFlashTask = null;
                        this.isCurrentlyUnstable = false;
                        this.updateFlashState(false);
                    }
                    this.getEnergyStorage().extractEnergy(this.keepAliveEnergyPerTick + morePower + this.shieldKeepAlive, false);
                    this.func_70296_d();
                } else {
                    this.attemptClose(StargateClosedReasonEnum.OUT_OF_POWER);
                }
            } else if (this.shieldKeepAlive > 0) {
                this.getEnergyStorage().extractEnergy(this.shieldKeepAlive, false);
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    protected void kawooshDestruction() {
        if (this.horizonKilling) {
            ArrayList entities = new ArrayList();
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < this.horizonSegments; ++i) {
                if (this.localKillingBoxes.size() <= i) continue;
                JSGAxisAlignedBB gBox = this.localKillingBoxes.get(i).offset(this.field_174879_c);
                entities.addAll(this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)gBox));
                for (BlockPos bPos : BlockPos.func_191532_a((int)((int)Math.floor(gBox.field_72340_a)), (int)((int)Math.floor(gBox.field_72338_b)), (int)((int)Math.floor(gBox.field_72339_c)), (int)((int)Math.ceil(gBox.field_72336_d) - 1), (int)((int)Math.ceil(gBox.field_72337_e) - 1), (int)((int)Math.ceil(gBox.field_72334_f) - 1))) {
                    blocks.add(bPos);
                }
            }
            for (JSGAxisAlignedBB lBox : this.localInnerEntityBoxes) {
                entities.addAll(this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)lBox.offset(this.field_174879_c)));
            }
            for (JSGAxisAlignedBB lBox : this.localInnerBlockBoxes) {
                JSGAxisAlignedBB gBox = lBox.offset(this.field_174879_c);
                for (BlockPos bPos : BlockPos.func_191532_a((int)((int)gBox.field_72340_a), (int)((int)gBox.field_72338_b), (int)((int)gBox.field_72339_c), (int)((int)gBox.field_72336_d - 1), (int)((int)gBox.field_72337_e - 1), (int)((int)gBox.field_72334_f - 1))) {
                    if (DHDBlock.SNOW_MATCHER.apply(this.field_145850_b.func_180495_p(bPos))) continue;
                    blocks.add(bPos);
                }
            }
            for (Entity entity : entities) {
                this.eventHorizon.horizonKill(entity);
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest(entity.func_180425_c())), this.targetPoint);
            }
            for (BlockPos dPos : blocks) {
                if (dPos.equals((Object)this.getGateCenterPos())) continue;
                IBlockState state = this.field_145850_b.func_180495_p(dPos);
                if (this.field_145850_b.func_175623_d(dPos) || !(state.func_185887_b(this.field_145850_b, dPos) >= 0.0f) || !JSGConfigUtil.canKawooshDestroyBlock(state)) continue;
                this.field_145850_b.func_175698_g(dPos);
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest(dPos)), this.targetPoint);
            }
        }
    }

    public abstract EnumSet<BiomeOverlayEnum> getSupportedOverlays();

    public BiomeOverlayEnum getBiomeOverlayWithOverride(boolean override) {
        return BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.getMergeHelper().getTopBlock().func_177971_a((Vec3i)this.field_174879_c), this.getSupportedOverlays());
    }

    protected boolean shouldAutoclose() {
        if (!this.randomIncomingIsActive && this.targetGatePos != null) {
            return this.getAutoCloseManager().shouldClose(this.targetGatePos);
        }
        return !this.randomIncomingIsActive;
    }

    protected void resetOpenedSince() {
        this.openedSince = -1L;
        this.func_70296_d();
    }

    protected void setOpenedSince() {
        this.openedSince = this.field_145850_b.func_82737_E();
        this.func_70296_d();
    }

    public void clearDHDSymbols() {
    }

    protected int doTimeLimitFunc() {
        boolean enabled;
        int morePower = 0;
        this.getOpenedSeconds();
        int configPower = JSGConfig.Stargate.openLimit.maxOpenedPowerDrawAfterLimit;
        int maxSeconds = JSGConfig.Stargate.openLimit.maxOpenedSeconds;
        StargateTimeLimitModeEnum limitMode = JSGConfig.Stargate.openLimit.maxOpenedWhat;
        if (this instanceof StargateClassicBaseTile) {
            StargateClassicBaseTile casted = (StargateClassicBaseTile)this;
            limitMode = StargateTimeLimitModeEnum.byId(casted.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.TIME_LIMIT_MODE.id).getEnumValue().getIntValue());
            configPower = casted.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.TIME_LIMIT_POWER.id).getIntValue();
            maxSeconds = casted.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.TIME_LIMIT_TIME.id).getIntValue();
        }
        boolean bl = enabled = limitMode != StargateTimeLimitModeEnum.DISABLED;
        if (enabled && this.getOpenedSeconds() >= (long)maxSeconds) {
            if (limitMode == StargateTimeLimitModeEnum.CLOSE_GATE) {
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                this.clearDHDSymbols();
            } else {
                morePower = (int)((double)this.getOpenedSeconds() / (double)maxSeconds * (double)configPower);
            }
        }
        return morePower;
    }

    public long getOpenedSeconds() {
        if (this.openedSince < 0L) {
            return -1L;
        }
        return (this.field_145850_b.func_82737_E() - this.openedSince) / 20L;
    }

    public String getOpenedSecondsToDisplayAsMinutes() {
        int minutes;
        long openedSeconds = this.getOpenedSeconds();
        int seconds = (int)(openedSeconds - (long)(60 * (minutes = (int)Math.floor((double)openedSeconds / 60.0))));
        String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        return minutes + ":" + secondsString + "min";
    }

    protected void extractEnergyByShield(int keepAlive) {
        this.shieldKeepAlive = keepAlive;
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
        JSG.ocWrapper.leaveWirelessNetwork(this);
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        JSG.ocWrapper.leaveWirelessNetwork(this);
        super.func_145843_s();
    }

    public void func_189667_a(Rotation rotation) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)rotation.func_185831_a(facing)));
    }

    protected abstract JSGAxisAlignedBB getHorizonKillingBox(boolean var1);

    protected abstract int getHorizonSegmentCount(boolean var1);

    protected abstract List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean var1);

    protected int getTicksPerHorizonSegment(boolean server) {
        return 12 / this.getHorizonSegmentCount(server);
    }

    public List<JSGAxisAlignedBB> getLocalKillingBoxes() {
        return this.localKillingBoxes;
    }

    public List<JSGAxisAlignedBB> getLocalInnerBlockBoxes() {
        return this.localInnerBlockBoxes;
    }

    public List<JSGAxisAlignedBB> getLocalInnerEntityBoxes() {
        return this.localInnerEntityBoxes;
    }

    public JSGAxisAlignedBB getRenderBoundingBoxForDisplay() {
        return this.getRenderBoundingBoxRaw().rotate(this.facingVertical).rotate(this.facing).offset(0.5, 0.0, 0.5);
    }

    protected StargateAbstractRendererState.StargateAbstractRendererStateBuilder getRendererStateServer() {
        return StargateAbstractRendererState.builder().setStargateState(this.stargateState);
    }

    protected abstract StargateAbstractRendererState createRendererStateClient();

    public StargateAbstractRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    protected void setRendererStateClient(StargateAbstractRendererState rendererState) {
        this.rendererStateClient = rendererState;
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, rendererState.doEventHorizonRender);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_LIGHTING_UPDATE_CLIENT, 10));
    }

    protected abstract JSGAxisAlignedBB getRenderBoundingBoxRaw();

    public void updateFacing(EnumFacing facing, EnumFacing verticalFacing, boolean server) {
        this.facing = facing;
        this.facingVertical = verticalFacing;
        this.eventHorizon = new EventHorizon(this.field_145850_b, this.field_174879_c, this.getGateCenterPos(), facing, verticalFacing, this.getHorizonTeleportBox(server));
        this.renderBoundingBox = this.getRenderBoundingBoxRaw().rotate(verticalFacing).rotate(facing).offset(0.5, 0.0, 0.5).offset(this.field_174879_c);
        JSGAxisAlignedBB kBox = this.getHorizonKillingBox(server);
        double width = kBox.field_72334_f - kBox.field_72339_c;
        width /= (double)this.getHorizonSegmentCount(server);
        this.localKillingBoxes = new ArrayList<JSGAxisAlignedBB>(this.getHorizonSegmentCount(server));
        for (int i = 0; i < this.getHorizonSegmentCount(server); ++i) {
            JSGAxisAlignedBB box = new JSGAxisAlignedBB(kBox.field_72340_a, kBox.field_72338_b, kBox.field_72339_c + width * (double)i, kBox.field_72336_d, kBox.field_72337_e, kBox.field_72339_c + width * (double)(i + 1));
            box = box.rotate(verticalFacing).rotate(facing).offset(0.5, 0.0, 0.5);
            this.localKillingBoxes.add(box);
        }
        this.localInnerBlockBoxes = new ArrayList<JSGAxisAlignedBB>();
        this.localInnerEntityBoxes = new ArrayList<JSGAxisAlignedBB>();
        for (JSGAxisAlignedBB lBox : this.getGateVaporizingBoxes(server)) {
            this.localInnerBlockBoxes.add(lBox.rotate(verticalFacing).rotate(facing).offset(0.5, 0.0, 0.5));
            this.localInnerEntityBoxes.add(lBox.grow(0.0, 0.0, -0.25).rotate(verticalFacing).rotate(facing).offset(0.5, 0.0, 0.5));
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public final boolean isMerged() {
        return this.isMerged;
    }

    public abstract StargateAbstractMergeHelper getMergeHelper();

    public final void updateMergeState(boolean shouldBeMerged, EnumFacing facing, EnumFacing facingVertical) {
        if (!shouldBeMerged) {
            if (this.isMerged) {
                this.onGateBroken();
            }
            if (this.stargateState.engaged()) {
                this.targetGatePos.getTileEntity().closeGate(StargateClosedReasonEnum.CONNECTION_LOST);
            }
        } else {
            JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_MERGE);
            this.onGateMerged();
        }
        if (this.isMerged == shouldBeMerged) {
            if (shouldBeMerged) {
                this.getMergeHelper().updateMembersBasePos((IBlockAccess)this.field_145850_b, this.field_174879_c, facing, facingVertical);
            }
            return;
        }
        this.isMerged = shouldBeMerged;
        IBlockState actualState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.getMergeHelper().matchBase(actualState)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, actualState.func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(!shouldBeMerged)), 2);
        }
        this.getMergeHelper().updateMembersMergeStatus(this.field_145850_b, this.field_174879_c, facing, facingVertical, shouldBeMerged);
        this.func_70296_d();
    }

    public void updatePassedEntities() {
        if (!this.stargateState.engaged()) {
            if (this.entitiesPassedLast.size() > 0) {
                this.entitiesPassedLast.clear();
            }
            this.func_70296_d();
            return;
        }
        AxisAlignedBB scanBox = new AxisAlignedBB(this.getGateCenterPos().func_177971_a(new Vec3i(-5, -5, -5)), this.getGateCenterPos().func_177971_a(new Vec3i(5, 5, 5)));
        final List entities = this.field_145850_b.func_72872_a(Entity.class, scanBox);
        ArrayList<Integer> ids = new ArrayList<Integer>(){
            {
                for (Entity e : entities) {
                    this.add(e.func_145782_y());
                }
            }
        };
        HashMap<Integer, Entity> clonedEntitiesLast = new HashMap<Integer, Entity>(){
            {
                this.putAll(StargateAbstractBaseTile.this.entitiesPassedLast);
            }
        };
        Iterator iterator = clonedEntitiesLast.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (ids.contains(i)) continue;
            this.entitiesPassedLast.remove(i);
        }
        this.func_70296_d();
    }

    public final void entityPassing(Entity entity, boolean inbound) {
        boolean isPlayer;
        if (inbound) {
            this.entitiesPassedLast.put(entity.func_145782_y(), entity);
        }
        if (isPlayer = entity instanceof EntityPlayerMP) {
            this.getAutoCloseManager().playerPassing();
        }
        this.func_70296_d();
        this.sendSignal(null, "stargate_traveler", inbound, isPlayer, entity.getClass().getSimpleName());
    }

    private void setHorizonFlashTask(ScheduledTask horizonFlashTask) {
        horizonFlashTask.setExecutor(this);
        horizonFlashTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.horizonFlashTask = horizonFlashTask;
        this.func_70296_d();
    }

    private void resetFlashingSequence() {
        this.flashIndex = 0;
        this.isCurrentlyUnstable = false;
    }

    private void updateFlashState(boolean flash) {
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.FLASH_STATE, new StargateFlashState(this.isCurrentlyUnstable)), this.targetPoint);
        if (this.targetGatePos != null) {
            BlockPos tPos = this.targetGatePos.gatePos;
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(tPos, StateTypeEnum.FLASH_STATE, new StargateFlashState(this.isCurrentlyUnstable)), new NetworkRegistry.TargetPoint(this.targetGatePos.dimensionID, (double)tPos.func_177958_n(), (double)tPos.func_177956_o(), (double)tPos.func_177952_p(), 512.0));
        }
    }

    public abstract void setLinkedDHD(BlockPos var1, int var2);

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return this.getRendererStateServer().build();
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return this.createRendererStateClient();
            }
            case RENDERER_UPDATE: {
                return new StargateRendererActionState();
            }
            case STARGATE_VAPORIZE_BLOCK_PARTICLES: {
                return new StargateVaporizeBlockParticlesRequest();
            }
            case FLASH_STATE: {
                return new StargateFlashState();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_STATE: {
                EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
                EnumFacing facingVertical = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_VERTICAL);
                this.setRendererStateClient(((StargateAbstractRendererState)state).initClient(this.field_174879_c, facing, facingVertical, this.getBiomeOverlayWithOverride(false)));
                this.updateFacing(facing, facingVertical, false);
                break;
            }
            case RENDERER_UPDATE: {
                if (this.getRendererStateClient() == null) break;
                switch (((StargateRendererActionState)state).action) {
                    case OPEN_GATE: {
                        this.getRendererStateClient().horizonSegments = 0;
                        this.getRendererStateClient().openGate(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case CLOSE_GATE: {
                        this.getRendererStateClient().closeGate(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case STARGATE_HORIZON_WIDEN: {
                        ++this.getRendererStateClient().horizonSegments;
                        break block0;
                    }
                    case STARGATE_HORIZON_SHRINK: {
                        --this.getRendererStateClient().horizonSegments;
                        break block0;
                    }
                }
                break;
            }
            case STARGATE_VAPORIZE_BLOCK_PARTICLES: {
                BlockPos b = ((StargateVaporizeBlockParticlesRequest)state).block;
                for (int i = 0; i < 20; ++i) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleWhiteSmoke(this.field_145850_b, (double)b.func_177958_n() + (Math.random() - 0.5), b.func_177956_o(), (double)b.func_177952_p() + (Math.random() - 0.5), 0.0, 0.0, false));
                }
                break;
            }
            case FLASH_STATE: {
                if (this.getRendererStateClient() == null) break;
                this.getRendererStateClient().horizonUnstable = ((StargateFlashState)state).flash;
                break;
            }
        }
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.scheduledTasks.add(scheduledTask);
        this.func_70296_d();
    }

    public void removeTask(ScheduledTask scheduledTask) {
        this.scheduledTasks.remove(scheduledTask);
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_OPEN_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.OPEN);
                break;
            }
            case STARGATE_HORIZON_LIGHT_BLOCK: {
                this.field_145850_b.func_175656_a(this.getGateCenterPos(), JSGBlocks.INVISIBLE_BLOCK.func_176223_P().func_177226_a((IProperty)JSGProps.HAS_COLLISIONS, (Comparable)Boolean.valueOf(false)));
                break;
            }
            case STARGATE_HORIZON_WIDEN: {
                if (!this.horizonKilling) {
                    this.horizonKilling = true;
                }
                ++this.horizonSegments;
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_WIDEN_ACTION), this.targetPoint);
                if (this.horizonSegments < this.getHorizonSegmentCount(true)) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, this.getTicksPerHorizonSegment(true)));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_SHRINK, this.getTicksPerHorizonSegment(true) + 12));
                break;
            }
            case STARGATE_HORIZON_SHRINK: {
                --this.horizonSegments;
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_SHRINK_ACTION), this.targetPoint);
                if (this.horizonSegments > 0) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_SHRINK, this.getTicksPerHorizonSegment(true) + 1));
                } else {
                    this.horizonKilling = false;
                }
                this.func_70296_d();
                break;
            }
            case STARGATE_CLOSE: {
                this.field_145850_b.func_175698_g(this.getGateCenterPos());
                this.disconnectGate();
                break;
            }
            case STARGATE_FAIL: {
                this.failGate();
                break;
            }
            case STARGATE_ENGAGE: {
                if (!this.verifyConnection()) break;
                this.engageGate();
                break;
            }
            case STARGATE_LIGHTING_UPDATE_CLIENT: {
                this.field_145850_b.func_175679_n(this.getGateCenterPos());
                this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.getGateCenterPos());
                break;
            }
            case HORIZON_FLASH: {
                this.isCurrentlyUnstable ^= true;
                if (this.isCurrentlyUnstable) {
                    ++this.flashIndex;
                    if (this.flashIndex == 1 && this.targetGatePos != null) {
                        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_FLICKER);
                        JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.WORMHOLE_FLICKER);
                        JSGSoundHelper.playSoundEvent(this.targetGatePos.getWorld(), this.targetGatePos.getTileEntity().getGateCenterPos(), SoundEventEnum.WORMHOLE_FLICKER);
                    }
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 3.0) + 3));
                } else if (this.flashIndex == 1) {
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 4.0) + 1));
                } else {
                    float mul = this.energySecondsToClose / (float)JSGConfig.Stargate.power.instabilitySeconds;
                    int min = (int)(15.0f * mul);
                    int off = (int)(20.0f * mul);
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, min + (int)(Math.random() * (double)off)));
                    this.resetFlashingSequence();
                }
                this.updateFlashState(this.isCurrentlyUnstable);
                this.func_70296_d();
                break;
            }
        }
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public float getEnergySecondsToClose() {
        return this.energySecondsToClose;
    }

    protected abstract StargateAbstractEnergyStorage getEnergyStorage();

    protected StargateEnergyRequired getEnergyRequiredToDial(StargatePos targetGatePos) {
        BlockPos sPos = this.field_174879_c;
        BlockPos tPos = targetGatePos.gatePos;
        DimensionType sourceDim = this.field_145850_b.field_73011_w.func_186058_p();
        DimensionType targetDim = targetGatePos.getWorld().field_73011_w.func_186058_p();
        if (sourceDim == DimensionType.OVERWORLD && targetDim == DimensionType.NETHER) {
            tPos = new BlockPos(tPos.func_177958_n() * 8, tPos.func_177956_o(), tPos.func_177952_p() * 8);
        } else if (sourceDim == DimensionType.NETHER && targetDim == DimensionType.OVERWORLD) {
            sPos = new BlockPos(sPos.func_177958_n() * 8, sPos.func_177956_o(), sPos.func_177952_p() * 8);
        }
        double distance = (int)sPos.func_185332_f(tPos.func_177958_n(), tPos.func_177956_o(), tPos.func_177952_p());
        distance = distance < 5000.0 ? (distance *= 0.8) : 5000.0 * Math.log10(distance) / Math.log10(5000.0);
        StargateEnergyRequired energyRequired = new StargateEnergyRequired(JSGConfig.Stargate.power.openingBlockToEnergyRatio, JSGConfig.Stargate.power.keepAliveBlockToEnergyRatioPerTick);
        energyRequired = energyRequired.mul(distance).add(StargateDimensionConfig.getCost(this.field_145850_b.field_73011_w.func_186058_p(), targetDim));
        if (this.dialedAddress.size() == 9) {
            energyRequired.mul(JSGConfig.Stargate.power.nineSymbolAddressMul);
        }
        if (this.dialedAddress.size() == 8) {
            energyRequired.mul(JSGConfig.Stargate.power.eightSymbolAddressMul);
        }
        return energyRequired;
    }

    public boolean hasEnergyToDial(StargatePos targetGatePos) {
        StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(targetGatePos);
        return this.getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        for (StargateAddress stargateAddress : this.gateAddressMap.values()) {
            compound.func_74782_a("address_" + stargateAddress.getSymbolType(), (NBTBase)stargateAddress.serializeNBT());
        }
        compound.func_74782_a("dialedAddress", (NBTBase)this.dialedAddress.serializeNBT());
        if (this.targetGatePos != null) {
            compound.func_74782_a("targetGatePos", (NBTBase)this.targetGatePos.serializeNBT());
        }
        if (this.connectedToGatePos != null) {
            compound.func_74782_a("connectedToGatePos", (NBTBase)this.connectedToGatePos.serializeNBT());
        }
        compound.func_74757_a("connectingToGate", this.connectingToGate);
        compound.func_74757_a("connectedToGate", this.connectedToGate);
        compound.func_74757_a("isMerged", this.isMerged);
        compound.func_74782_a("autoCloseManager", (NBTBase)this.getAutoCloseManager().serializeNBT());
        compound.func_74768_a("keepAliveCostPerTick", this.keepAliveEnergyPerTick);
        if (this.stargateState != null) {
            compound.func_74768_a("stargateState", this.stargateState.id);
        }
        compound.func_74782_a("scheduledTasks", (NBTBase)ScheduledTask.serializeList(this.scheduledTasks));
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74757_a("horizonKilling", this.horizonKilling);
        compound.func_74768_a("horizonSegments", this.horizonSegments);
        compound.func_74772_a("openedSince", this.openedSince);
        compound.func_74768_a("facingVertical", this.facingVertical == EnumFacing.UP ? 2 : (this.facingVertical == EnumFacing.DOWN ? 1 : 0));
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            if (!compound.func_74764_b("address_" + symbolType)) continue;
            this.gateAddressMap.put(symbolType, new StargateAddress(compound.func_74775_l("address_" + symbolType)));
        }
        this.dialedAddress.deserializeNBT(compound.func_74775_l("dialedAddress"));
        if (compound.func_74764_b("targetGatePos")) {
            this.targetGatePos = new StargatePos(this.getSymbolType(), compound.func_74775_l("targetGatePos"));
        }
        if (compound.func_74764_b("connectedToGatePos")) {
            this.connectedToGatePos = new StargatePos(this.getSymbolType(), compound.func_74775_l("connectedToGatePos"));
        }
        this.connectingToGate = compound.func_74767_n("connectingToGate");
        this.connectedToGate = compound.func_74767_n("connectedToGate");
        this.isMerged = compound.func_74767_n("isMerged");
        this.getAutoCloseManager().deserializeNBT(compound.func_74775_l("autoCloseManager"));
        try {
            ScheduledTask.deserializeList(compound.func_74775_l("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.warn("Exception at reading NBT");
            JSG.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it");
            e.printStackTrace();
        }
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        this.keepAliveEnergyPerTick = compound.func_74762_e("keepAliveCostPerTick");
        this.stargateState = EnumStargateState.valueOf(compound.func_74762_e("stargateState"));
        if (this.stargateState == null) {
            this.stargateState = EnumStargateState.IDLE;
        }
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        this.horizonKilling = compound.func_74767_n("horizonKilling");
        this.horizonSegments = compound.func_74762_e("horizonSegments");
        this.openedSince = compound.func_74763_f("openedSince");
        if (compound.func_74764_b("facingVertical")) {
            int fVertIndex = compound.func_74762_e("facingVertical");
            this.facingVertical = fVertIndex == 2 ? EnumFacing.UP : (fVertIndex == 1 ? EnumFacing.DOWN : EnumFacing.SOUTH);
        }
        super.func_145839_a(compound);
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        if (!this.stargateState.idle()) {
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"Stop any gate activity before preparation.", (Object[])new Object[0]);
            return false;
        }
        this.gateAddressMap.clear();
        this.dialedAddress.clear();
        this.scheduledTasks.clear();
        return true;
    }

    public SymbolInterface getSymbolFromNameIndex(Object nameIndex) throws IllegalArgumentException {
        SymbolInterface symbol = null;
        if (nameIndex instanceof Integer) {
            symbol = this.getSymbolType().valueOfSymbol((Integer)nameIndex);
        } else if (nameIndex instanceof byte[]) {
            symbol = this.getSymbolType().fromEnglishName(new String((byte[])nameIndex));
        } else if (nameIndex instanceof String) {
            symbol = this.getSymbolType().fromEnglishName((String)nameIndex);
        }
        if (symbol == null) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        return symbol;
    }

    public int x() {
        return this.field_174879_c.func_177958_n();
    }

    public int y() {
        return this.field_174879_c.func_177956_o();
    }

    public int z() {
        return this.field_174879_c.func_177952_p();
    }

    public World world() {
        return this.field_145850_b;
    }

    @Optional.Method(modid="opencomputers")
    public void receivePacket(Packet packet, WirelessEndpoint sender) {
        if (this.stargateState.engaged() && packet.ttl() > 0) {
            Network.sendWirelessPacket((WirelessEndpoint)this.targetGatePos.getTileEntity(), (double)20.0, (Packet)packet.hop());
        }
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        JSG.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getJSGVersion(Context context, Arguments args) {
        return new Object[]{"1.12.2-4.11.0.8"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(getter=true)
    public Object[] stargateAddress(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null};
        }
        HashMap<SymbolTypeEnum, List<String>> map = new HashMap<SymbolTypeEnum, List<String>>(3);
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            map.put(symbolType, this.gateAddressMap.get(symbolType).getNameList());
        }
        return new Object[]{map};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(getter=true)
    public Object[] dialedAddress(Context context, Arguments args) {
        Object[] objectArray;
        if (this.isMerged && !this.stargateState.incoming() && !this.stargateState.unstable() && !this.stargateState.notInitiating()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.dialedAddress;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = null;
        }
        return objectArray;
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.isMerged ? Integer.valueOf(this.getEnergyStorage().getEnergyStored()) : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.isMerged ? Integer.valueOf(this.getEnergyStorage().getMaxEnergyStored()) : null};
    }

    protected static class ResultTargetValid {
        public final StargateOpenResult result;
        public final boolean targetVaild;

        public ResultTargetValid(StargateOpenResult result, boolean targetVaild) {
            this.result = result;
            this.targetVaild = targetVaild;
        }
    }
}

