/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.energy;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.container.capacitor.CapacitorContainerGuiUpdate;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.energy.CapacitorPowerLevelUpdate;
import tauri.dev.jsg.util.JSGItemStackHandler;

public class CapacitorTile
extends TileEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface {
    protected final ItemStackHandler itemStackHandler = new JSGItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.hasCapability(CapabilityEnergy.ENERGY, null);
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CapacitorTile.this.func_70296_d();
        }
    };
    private final StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            CapacitorTile.this.func_70296_d();
        }
    };
    protected int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    private NetworkRegistry.TargetPoint targetPoint;
    private int powerLevel;
    private int lastPowerLevel;

    public NetworkRegistry.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IEnergyStorage targetEnergyStorage;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
                int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.Stargate.power.stargateMaxEnergyTransfer, true);
                extracted = Objects.requireNonNull((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            ItemStack stack = this.itemStackHandler.getStackInSlot(0);
            if (!stack.func_190926_b() && stack.hasCapability(CapabilityEnergy.ENERGY, null) && (targetEnergyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.Stargate.power.stargateMaxEnergyTransfer, true);
                extracted = targetEnergyStorage.receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            this.powerLevel = Math.round((float)this.getEnergyStorage().getEnergyStored() / (float)this.getEnergyStorage().getMaxEnergyStored() * 10.0f);
            if (this.powerLevel != this.lastPowerLevel) {
                JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE)), this.targetPoint);
                this.lastPowerLevel = this.powerLevel;
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
        super.func_145839_a(compound);
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate(this.powerLevel);
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate(this.getEnergyStorage().getEnergyStored(), this.energyTransferedLastTick);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate();
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                this.powerLevel = ((CapacitorPowerLevelUpdate)state).powerLevel;
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                break;
            }
            case GUI_UPDATE: {
                CapacitorContainerGuiUpdate guiUpdate = (CapacitorContainerGuiUpdate)state;
                this.getEnergyStorage().setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                break;
            }
        }
    }
}

