/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.zpm;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.item.energy.ZPMItemBlockCreative;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.tileentity.energy.ZPMTile;
import tauri.dev.jsg.util.JSGTextureLightningHelper;

public class ZPMRenderer
extends TileEntitySpecialRenderer<ZPMTile> {
    public void render(@Nonnull ZPMTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        int level = te.getPowerLevel();
        if (level > 5) {
            level = 5;
        }
        if (level < 0) {
            level = 0;
        }
        GlStateManager.func_179137_b((double)0.32, (double)0.27, (double)0.43);
        ZPMRenderer.renderZPM(te.func_145831_w(), te.func_174877_v(), level, 0.8f, te.getType());
        GlStateManager.func_179121_F();
    }

    public static void renderZPM(World world, BlockPos pos, int powerLevel, float size, ZPMModelType type) {
        ZPMRenderer.renderZPM(world, pos, powerLevel, size, false, type);
    }

    public static void renderZPM(World world, BlockPos pos, int powerLevel, float size, boolean on, @Nullable ZPMModelType type) {
        if (powerLevel < 0) {
            return;
        }
        if (type == null) {
            type = ZPMModelType.NORMAL;
        }
        if (type == ZPMModelType.CREATIVE) {
            powerLevel = 5;
        }
        if (powerLevel > 5) {
            powerLevel = 5;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        JSGTextureLightningHelper.lightUpTexture(1.0f);
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        TextureLoader.getTexture(TextureLoader.getTextureResource("zpm/zpm" + powerLevel + (on ? "" : "_off") + type.suffix + ".png")).bindTexture();
        ElementEnum.ZPM.render();
        JSGTextureLightningHelper.resetLight(world, pos);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static enum ZPMModelType {
        NORMAL(0, ""),
        CREATIVE(1, "_creative"),
        EXPLOSIVE(2, "");

        public final int id;
        public final String suffix;

        private ZPMModelType(int id, String suffix) {
            this.id = id;
            this.suffix = suffix;
        }

        public static ZPMModelType byId(int id) {
            if (id < 0) {
                return null;
            }
            if (id > ZPMModelType.values().length - 1) {
                return null;
            }
            for (ZPMModelType z : ZPMModelType.values()) {
                if (z.id != id) continue;
                return z;
            }
            return null;
        }

        public static ZPMModelType byStack(ItemStack stack) {
            NBTTagCompound tag;
            if (stack.func_77973_b() instanceof ZPMItemBlockCreative) {
                return CREATIVE;
            }
            if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null && tag.func_74764_b("corrupted") && tag.func_74767_n("corrupted")) {
                return EXPLOSIVE;
            }
            return NORMAL;
        }
    }
}

