/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.zpm;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.zpm.ZPMRenderer;
import tauri.dev.jsg.tileentity.energy.ZPMHubTile;
import tauri.dev.jsg.util.JSGMinecraftHelper;
import tauri.dev.jsg.util.JSGTextureLightningHelper;

public class ZPMHubRenderer
extends TileEntitySpecialRenderer<ZPMHubTile> {
    public void render(@Nonnull ZPMHubTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        long tick = te.func_145831_w().func_82737_E();
        double stage = (double)(tick - te.animationStart) / (double)te.getAnimationLength();
        if (!te.isAnimating) {
            stage = te.isSlidingUp ? 1.0 : 0.0;
        } else if (!te.isSlidingUp) {
            stage = 1.0 - stage;
        }
        float plusY = (float)stage * 0.3f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179114_b((float)(te.facingAngle == 0.0f ? 180.0f : (te.facingAngle == -180.0f || te.facingAngle == 180.0f ? 0.0f : te.facingAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderMainObject(te);
        for (int i = 0; i < 3; ++i) {
            this.renderZPM(i, te, plusY);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderMainObject(ZPMHubTile tile) {
        boolean zpmsDown = false;
        if (!tile.isAnimating) {
            zpmsDown = !tile.isSlidingUp;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
        GlStateManager.func_179139_a((double)0.025, (double)0.025, (double)0.025);
        ElementEnum.ZPM_HUB.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        int zpmHubLights = (int)Math.round(Math.abs(Math.sin((float)JSGMinecraftHelper.getClientTick() / 8.0f)) * 5.0) + 1;
        if (tile.zpm1Level == -1 && tile.zpm2Level == -1 && tile.zpm3Level == -1) {
            zpmHubLights = 0;
        }
        if (zpmHubLights > 5) {
            zpmHubLights = 5;
        }
        if (zpmHubLights < 0) {
            zpmHubLights = 0;
        }
        if (!zpmsDown) {
            zpmHubLights = 0;
        }
        if (zpmHubLights > 0) {
            JSGTextureLightningHelper.lightUpTexture(1.0f);
        }
        TextureLoader.getTexture(TextureLoader.getTextureResource("zpm/hub/pg_lights" + zpmHubLights + ".jpg")).bindTexture();
        ElementEnum.ZPM_HUB_LIGHTS.render();
        JSGTextureLightningHelper.resetLight(tile.func_145831_w(), tile.func_174877_v());
        GlStateManager.func_179121_F();
    }

    protected void renderZPM(int zpmId, ZPMHubTile te, float plusY) {
        int level = -1;
        ZPMRenderer.ZPMModelType type = ZPMRenderer.ZPMModelType.NORMAL;
        float zx = 0.0f;
        float zy = 0.9f;
        float zz = 0.0f;
        switch (zpmId) {
            case 0: {
                level = te.zpm1Level;
                type = te.zpm1Type;
                zx = 0.2f;
                zz = 0.18f;
                break;
            }
            case 1: {
                level = te.zpm2Level;
                type = te.zpm2Type;
                zx = -0.33f;
                zz = 0.18f;
                break;
            }
            case 2: {
                level = te.zpm3Level;
                type = te.zpm3Type;
                zx = -0.07f;
                zz = -0.27f;
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)zx, (float)(zy + plusY), (float)zz);
        ZPMRenderer.renderZPM(this.func_178459_a(), te.func_174877_v(), level, 0.4f, !te.isSlidingUp && !te.isAnimating, type);
        GlStateManager.func_179121_F();
    }
}

