/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.transportrings;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;

public class Ring {
    private int index;
    private World world;
    private boolean shouldRender;
    private boolean shouldAnimate;
    private boolean ringsUprising;
    private long animationStart;
    private double y;
    private double yMax;
    public JSGTileEntityConfig config = new JSGTileEntityConfig();

    public Ring(int index) {
        this.shouldRender = false;
        this.y = 0.0;
        this.index = index;
        this.yMax = index;
    }

    public Ring(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.index);
        buf.writeBoolean(this.shouldRender);
        buf.writeBoolean(this.shouldAnimate);
        buf.writeBoolean(this.ringsUprising);
        buf.writeLong(this.animationStart);
        buf.writeDouble(this.y);
        buf.writeDouble(this.yMax);
    }

    public void fromBytes(ByteBuf buf) {
        this.index = buf.readInt();
        this.shouldRender = buf.readBoolean();
        this.shouldAnimate = buf.readBoolean();
        this.ringsUprising = buf.readBoolean();
        this.animationStart = buf.readLong();
        this.y = buf.readDouble();
        this.yMax = buf.readDouble();
    }

    public void render(double partialTicks, ElementEnum type, int distance, float addToYMax) {
        if (this.world == null) {
            return;
        }
        this.yMax = distance >= 0 ? (double)(distance * 2 - this.index) + 1.5 + (double)addToYMax : (double)(distance * 2 + this.index) - 3.0 - (double)addToYMax;
        if (this.shouldRender || this.config.getOption(TransportRingsAbstractTile.ConfigOptions.ENABLE_NONACTIVE_RENDER.id).getBooleanValue()) {
            double y = this.y;
            if (!this.shouldRender) {
                y = 0.0;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)y, (double)0.0);
            type.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
            GlStateManager.func_179121_F();
        }
        if (this.shouldAnimate) {
            double effTick = (double)(this.world.func_82737_E() - this.animationStart) + partialTicks;
            if ((effTick /= 2.7) > Math.PI) {
                effTick = Math.PI;
                this.shouldAnimate = false;
            }
            float cos = MathHelper.func_76134_b((float)((float)effTick));
            if (this.ringsUprising) {
                cos *= -1.0f;
            }
            this.y = (double)((cos + 1.0f) / 2.0f) * this.yMax;
            if (!this.ringsUprising && effTick == Math.PI) {
                this.shouldRender = false;
            }
        }
    }

    public void animate(boolean ringsUprising) {
        this.ringsUprising = ringsUprising;
        this.shouldRender = true;
        this.animationStart = this.world.func_82737_E();
        this.shouldAnimate = true;
    }

    public void setTop() {
        this.y = this.yMax;
        this.shouldAnimate = false;
        this.shouldRender = true;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setConfig(JSGTileEntityConfig config) {
        this.config = config;
    }

    public void setDown() {
        this.shouldAnimate = false;
        this.shouldRender = false;
    }
}

