/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.world.World;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.model.ModelLoader;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateClassicRenderer;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.renderer.stargate.StargateUniverseRendererState;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.JSGTextureLightningHelper;

public class StargateUniverseRenderer
extends StargateClassicRenderer<StargateUniverseRendererState> {
    private static final float GATE_DIAMETER = 8.67415f;
    private static final float IRIS_DARK_COLOR = 0.6f;

    @Override
    public float getGateDiameter() {
        return 8.67415f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.14;
    }

    @Override
    protected void renderGate(StargateAbstractBaseTile te, StargateUniverseRendererState rendererState, double partialTicks) {
        this.setGateHeatColor(rendererState);
        float angularRotation = rendererState.spinHelper.getCurrentSymbol().getAngle();
        if (rendererState.spinHelper.getIsSpinning()) {
            angularRotation += rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks);
        }
        GlStateManager.func_179114_b((float)(-angularRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
        GlStateManager.func_179094_E();
        ElementEnum.UNIVERSE_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179121_F();
        this.renderChevrons(rendererState, partialTicks);
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(rendererState.getBiomeOverlay());
        GlStateManager.func_179140_f();
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (symbol.modelResource == null) continue;
            float color = rendererState.getSymbolColor(symbol) + 0.25f;
            GlStateManager.func_179094_E();
            JSGTextureLightningHelper.lightUpTexture(rendererState.getSymbolColor(symbol) / 0.6f);
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
            ModelLoader.getModel(symbol.modelResource).render();
            this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179145_e();
        rendererState.iterate(this.func_178459_a(), partialTicks);
    }

    @Override
    protected String getEventHorizonTexturePath(StargateAbstractRendererState rendererState, boolean kawoosh) {
        String texture;
        String string = texture = kawoosh ? "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg" : "textures/tesr/event_horizon_animated_unstable.jpg";
        if (JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon || !StargateUniverseRenderer.isEhAnimatedLoaded()) {
            texture = "textures/tesr/event_horizon_unstable.jpg";
        }
        return texture;
    }

    @Override
    protected void renderKawoosh(StargateAbstractRendererState rendererState, double partialTicks) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.05f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        super.renderKawoosh(rendererState, partialTicks);
    }

    @Override
    public void renderIris(double partialTicks, World world, StargateUniverseRendererState rendererState, boolean backOnly) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.05f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.887f, (float)0.887f, (float)0.887f);
        super.renderIris(partialTicks, world, rendererState, backOnly);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void renderChevron(StargateUniverseRendererState rendererState, double partialTicks, ChevronEnum chevron, boolean onlyLight) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        if (onlyLight) {
            float color = rendererState.chevronTextureList.getColor(chevron);
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
        } else {
            this.setGateHeatColor(rendererState);
        }
        TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron, onlyLight)).bindTexture();
        ElementEnum.UNIVERSE_CHEVRON.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setIrisHeatColor(StargateClassicRendererState rendererState, float red) {
        GlStateManager.func_179124_c((float)(0.6f + red * 2.0f), (float)0.6f, (float)0.6f);
    }
}

