/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRenderer;

public class StargateRendererStatic {
    static final float eventHorizonRadius = 3.790975f;
    private static final int quads = 16;
    private static final int sections = 72;
    private static final float sectionAngle = 0.08726646f;
    private static final float innerCircleRadius = 0.25f;
    private static final float quadStep = 0.22131094f;
    private static List<Float> offsetList = new ArrayList<Float>();
    private static List<Float> sin = new ArrayList<Float>();
    private static List<Float> cos = new ArrayList<Float>();
    private static List<Float> quadRadius = new ArrayList<Float>();
    static InnerCircle innerCircle;
    static List<QuadStrip> quadStrips;
    private static Random rand;
    static final float kawooshRadius = 2.5f;
    private static final float kawooshSize = 7.0f;
    private static final float kawooshSections = 128.0f;
    static Map<Float, Float> Z_RadiusMap;

    private static float getRandomFloat() {
        return rand.nextFloat() * 2.0f - 1.0f;
    }

    private static float getOffset(int index, float tick, float mul, int quadStripIndex) {
        return (float)(Math.sin(tick / 4.0f + offsetList.get(index).floatValue()) * (double)mul * (double)((float)quadStripIndex / 4.0f) * (double)(quadStripIndex - quadStrips.size()) / 400.0);
    }

    private static float toUV(float coord) {
        return (coord + 1.0f) / 2.0f;
    }

    private static void initEventHorizon() {
        int i;
        for (i = 0; i < 1224; ++i) {
            offsetList.add(Float.valueOf(StargateRendererStatic.getRandomFloat() * 3.0f));
        }
        for (i = 0; i <= 72; ++i) {
            sin.add(Float.valueOf(MathHelper.func_76126_a((float)(0.08726646f * (float)i))));
            cos.add(Float.valueOf(MathHelper.func_76134_b((float)(0.08726646f * (float)i))));
        }
        innerCircle = new InnerCircle();
        for (i = 0; i <= 16; ++i) {
            quadRadius.add(Float.valueOf(0.25f + 0.22131094f * (float)i));
        }
        for (i = 0; i < 16; ++i) {
            quadStrips.add(new QuadStrip(i));
        }
    }

    private static void initKawoosh() {
        Z_RadiusMap = new LinkedHashMap<Float, Float>();
        float begin = 0.0f;
        float end = 0.545f;
        float rng = end - begin;
        float step = rng / 128.0f;
        boolean first = true;
        float scaleX = 7.0f / rng;
        float scaleY = 1.0f;
        int i = 0;
        while ((float)i <= 128.0f) {
            float p;
            float c;
            float b;
            float a;
            float x = begin + step * (float)i;
            float y = 0.0f;
            float border1 = 0.2575f;
            float border2 = 0.4241f;
            float border3 = 0.4577f;
            if (x >= 0.0f && x <= border1) {
                a = 2.0f;
                b = -4.7f;
                c = 2.1f;
                p = x + b / 20.0f;
                y = a / 2.0f * (p * p) + c / 30.0f;
                if (first) {
                    first = false;
                    scaleY = 2.5f / y;
                }
            } else if (x > border1 && x <= border2) {
                a = 1.4f;
                b = -4.3f;
                c = 1.4f;
                p = x + b / 20.0f;
                y = a / 5.0f * (p * p) + c / 20.0f;
            } else if (x > border2 && x <= border3) {
                a = -7.4f;
                b = -8.6f;
                c = 3.3f;
                p = x + b / 20.0f;
                y = a * (p * p) + c / 40.0f;
            } else if (x > border3 && x <= 0.545f) {
                a = 5.2f;
                y = (float)((double)(a / 20.0f) * Math.sqrt(0.545f - x));
            }
            Z_RadiusMap.put(Float.valueOf(x * scaleX), Float.valueOf(y * scaleY));
            ++i;
        }
    }

    static {
        quadStrips = new ArrayList<QuadStrip>();
        rand = new Random();
        StargateRendererStatic.initEventHorizon();
        StargateRendererStatic.initKawoosh();
    }

    public static class QuadStrip {
        private List<Float> x = new ArrayList<Float>();
        private List<Float> y = new ArrayList<Float>();
        private List<Float> tx = new ArrayList<Float>();
        private List<Float> ty = new ArrayList<Float>();
        private int quadStripIndex;

        public QuadStrip(int quadStripIndex) {
            this(quadStripIndex, ((Float)quadRadius.get(quadStripIndex)).floatValue(), ((Float)quadRadius.get(quadStripIndex + 1)).floatValue(), null);
        }

        public QuadStrip(int quadStripIndex, float innerRadius, float outerRadius, Float tick) {
            this.quadStripIndex = quadStripIndex;
            this.recalculate(innerRadius, outerRadius, tick);
        }

        public void recalculate(float innerRadius, float outerRadius, Float tick) {
            ArrayList<Float> radius = new ArrayList<Float>();
            ArrayList<Float> texMul = new ArrayList<Float>();
            radius.add(Float.valueOf(innerRadius));
            radius.add(Float.valueOf(outerRadius));
            for (int i = 0; i < 2; ++i) {
                texMul.add(Float.valueOf(((Float)radius.get(i)).floatValue() / 3.790975f));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 72; ++i) {
                    float rad = ((Float)radius.get(k)).floatValue();
                    if (tick != null) {
                        rad += StargateRendererStatic.getOffset(i, tick.floatValue(), 1.0f, this.quadStripIndex) * 2.0f;
                    }
                    this.x.add(Float.valueOf(rad * ((Float)sin.get(i)).floatValue()));
                    this.y.add(Float.valueOf(rad * ((Float)cos.get(i)).floatValue()));
                    this.tx.add(Float.valueOf(StargateRendererStatic.toUV(((Float)sin.get(i)).floatValue() * ((Float)texMul.get(k)).floatValue())));
                    this.ty.add(Float.valueOf(StargateRendererStatic.toUV(((Float)cos.get(i)).floatValue() * ((Float)texMul.get(k)).floatValue())));
                }
            }
        }

        public void render(float tick, boolean white, Float alpha, float mul) {
            this.render(tick, null, null, white, alpha, mul);
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride) {
            this.render(tick, null, null, white, alpha, mul, false, false, animationOverride);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul) {
            this.render(tick, outerZ, innerZ, white, alpha, mul, false, false, (byte)0);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul, boolean reversed, boolean red, byte animationOverride) {
            int i;
            boolean animate;
            boolean bl = animate = !JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon && StargateAbstractRenderer.isEhAnimatedLoaded();
            if (animationOverride == -1) {
                animate = false;
            }
            if (animationOverride == 1) {
                animate = true;
            }
            if (white) {
                GlStateManager.func_179090_x();
                if (alpha.floatValue() > 0.5f) {
                    alpha = Float.valueOf(1.0f - alpha.floatValue());
                }
            }
            if (alpha != null) {
                GL11.glColor4d((double)1.0, (double)(red ? 0.0 : 1.0), (double)(red ? 0.0 : 1.0), (double)alpha.floatValue());
            }
            GL11.glBegin((int)8);
            int index = 0;
            int texIndex = (int)(tick * 4.0f % 185.0f);
            float xTexOffset = (float)(texIndex % 14) / 14.0f;
            float yTexOffset = (float)(texIndex / 14) / 14.0f;
            int n = i = reversed ? 0 : 72;
            while (reversed && i <= 72 || !reversed && i >= 0) {
                index = i == 72 ? 0 : i;
                float z = outerZ != null ? outerZ.floatValue() : StargateRendererStatic.getOffset(index + 72 * this.quadStripIndex, tick * mul, mul, this.quadStripIndex);
                float xTex = this.tx.get(index).floatValue();
                float yTex = this.ty.get(index).floatValue();
                if (animate) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                if (!white) {
                    GL11.glTexCoord2f((float)xTex, (float)yTex);
                }
                GL11.glVertex3f((float)this.x.get(index).floatValue(), (float)this.y.get(index).floatValue(), (float)z);
                xTex = this.tx.get(index += 72).floatValue();
                yTex = this.ty.get(index).floatValue();
                if (animate) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                z = innerZ != null ? innerZ.floatValue() : StargateRendererStatic.getOffset(index + 72 * this.quadStripIndex, tick * mul, mul, this.quadStripIndex + 1);
                if (!white) {
                    GL11.glTexCoord2f((float)xTex, (float)yTex);
                }
                GL11.glVertex3f((float)this.x.get(index).floatValue(), (float)this.y.get(index).floatValue(), (float)z);
                i += reversed ? 1 : -1;
            }
            GL11.glEnd();
            if (white) {
                GlStateManager.func_179098_w();
            }
            if (alpha != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static class InnerCircle {
        private List<Float> x = new ArrayList<Float>();
        private List<Float> y = new ArrayList<Float>();
        private List<Float> tx = new ArrayList<Float>();
        private List<Float> ty = new ArrayList<Float>();

        public InnerCircle() {
            float texMul = 0.065946095f;
            for (int i = 0; i < 72; ++i) {
                this.x.add(Float.valueOf(((Float)sin.get(i)).floatValue() * 0.25f));
                this.y.add(Float.valueOf(((Float)cos.get(i)).floatValue() * 0.25f));
                this.tx.add(Float.valueOf(StargateRendererStatic.toUV(((Float)sin.get(i)).floatValue() * texMul)));
                this.ty.add(Float.valueOf(StargateRendererStatic.toUV(((Float)cos.get(i)).floatValue() * texMul)));
            }
        }

        public void render(float tick, boolean white, Float alpha, float mul) {
            this.render(tick, white, alpha, mul, (byte)0);
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride) {
            boolean animated;
            boolean bl = animated = !JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon && StargateAbstractRenderer.isEhAnimatedLoaded();
            if (animationOverride == -1) {
                animated = false;
            }
            if (animationOverride == 1) {
                animated = true;
            }
            if (white) {
                GlStateManager.func_179090_x();
                if (alpha.floatValue() > 0.5f) {
                    alpha = Float.valueOf(1.0f - alpha.floatValue());
                }
            }
            GL11.glBegin((int)6);
            int texIndex = (int)(tick * 4.0f % 185.0f);
            float xTexOffset = (float)(texIndex % 14) / 14.0f;
            float yTexOffset = (float)(texIndex / 14) / 14.0f;
            float xTex = 0.5f;
            float yTex = 0.5f;
            if (animated) {
                xTex /= 14.0f;
                xTex += xTexOffset;
                yTex /= 14.0f;
                yTex += yTexOffset;
            } else {
                yTex *= -1.0f;
            }
            if (alpha != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
            }
            if (!white) {
                GL11.glTexCoord2f((float)xTex, (float)yTex);
            }
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            int index = 0;
            for (int i = 72; i >= 0; --i) {
                index = i == 72 ? 0 : i;
                xTex = this.tx.get(index).floatValue();
                yTex = this.ty.get(index).floatValue();
                if (animated) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                if (!white) {
                    GL11.glTexCoord2f((float)xTex, (float)yTex);
                }
                GL11.glVertex3f((float)this.x.get(index).floatValue(), (float)this.y.get(index).floatValue(), (float)StargateRendererStatic.getOffset(index, tick * mul, mul, 0));
            }
            GL11.glEnd();
            if (alpha != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (white) {
                GlStateManager.func_179098_w();
            }
        }
    }
}

